package org.andromda.cartridges.arc;

/**
 * Cardinality Responsibility Class
 */
public class CardinalityResponsibility extends Responsibility {
	public static final String CARDINALITY_TYPE_ID="CardinalityType";
	public static final String LOWER_ID="Lower";
	public static final String UPPER_ID="Upper";
	public static final String ELEMENT_CLASS_NAME_ID="ElementClassName";

	private String cardinalityType="";
	private Integer lower;
	private Integer upper;
	private String elementClassName="";

	public String getCardinalityType() { return cardinalityType; }
	public Integer getLower() { return lower; }
	public Integer getUpper() { return upper; }
	public String getElementClassName() { return elementClassName; }

	public void setCardinalityType(String cardinalityType) { this.cardinalityType=cardinalityType; }
	public void setLower(Integer lower) { this.lower=lower; }
	public void setUpper(Integer upper) { this.upper=upper; }
	public void setElementClassName(String elementClassName) { this.elementClassName=elementClassName; }

	public Object get(String id) {
		if(id.equals(CARDINALITY_TYPE_ID)) return getCardinalityType();
		else if(id.equals(LOWER_ID)) return getLower();
		else if(id.equals(UPPER_ID)) return getUpper();
		else if(id.equals(ELEMENT_CLASS_NAME_ID)) return getElementClassName();
		else return super.get(id);
	}

	public void set(String id, Object value) {
		if(id.equals(CARDINALITY_TYPE_ID)) setCardinalityType((String)value);
		else if(id.equals(LOWER_ID)) setLower((Integer)value);
		else if(id.equals(UPPER_ID)) setUpper((Integer)value);
		else if(id.equals(ELEMENT_CLASS_NAME_ID)) setElementClassName((String)value);
		else super.set(id, value);
	}

	public String getDescription() {
		String description="";
		if(getCardinalityType().equals("Association")) {
			description="The class '"+getModelElementName()+"' must have ";
			if(getLower().intValue() == getUpper().intValue()) description+=getUpper();
			else {
				if(getLower().intValue() != 0) description+="at least "+getLower();
				if(getLower().intValue() != 0 && getUpper().intValue() != -1) description+=" and ";
				if(getUpper().intValue() != -1) description+="at the most "+getUpper();
			}
			description+=" '"+getElementClassName()+"' classes associated.";
		}
		return description;
	}

	public void show() {
		if(getCardinalityType()==null) System.out.println("cardinality type: null");
		else System.out.println("cardinality type: "+getCardinalityType());
		System.out.println("lower: "+getLower());
		System.out.println("upper: "+getUpper());
		if(getElementClassName()==null) System.out.println("element class name: null");
		else System.out.println("element class name: "+getElementClassName());
		super.show();
	}

	public CardinalityResponsibility() {
		setName("Cardinality");
	}

	public CardinalityResponsibility(String modelElement, String modelElementName, String cardinalityType, Integer lower, Integer upper, String elementClassName) {
		setName("Cardinality");
		setModelElement(modelElement);
		setModelElementName(modelElementName);
		setCardinalityType(cardinalityType);
		setLower(lower);
		setUpper(upper);
		setElementClassName(elementClassName);
	}
}
