package org.andromda.cartridges.arc;

/**
 * Constraint Responsibility Class
 */
public class ConstraintResponsibility extends Responsibility {
	public static final String CONSTRAINT_TYPE_ID="ConstraintType";
	public static final String CONSTRAINT_NAME_ID="ConstraintName";
	public static final String CONSTRAINT_BODY_ID="ConstraintBody";

	private String constraintType="";
	private String constraintName="";
	private String constraintBody="";

	public String getConstraintType() { return constraintType; }
	public String getConstraintName() { return constraintName; }
	public String getConstraintBody() { return constraintBody; }

	public void setConstraintType(String constraintType) { this.constraintType=constraintType; }
	public void setConstraintName(String constraintName) { this.constraintName=constraintName; }
	public void setConstraintBody(String constraintBody) { this.constraintBody=constraintBody; }

	public Object get(String id) {
		if(id.equals(CONSTRAINT_TYPE_ID)) return getConstraintType();
		else if(id.equals(CONSTRAINT_NAME_ID)) return getConstraintName();
		else if(id.equals(CONSTRAINT_BODY_ID)) return getConstraintBody();
		else return super.get(id);
	}

	public void set(String id, Object value) {
		if(id.equals(CONSTRAINT_TYPE_ID)) setConstraintType((String)value);
		else if(id.equals(CONSTRAINT_NAME_ID)) setConstraintName((String)value);
		else if(id.equals(CONSTRAINT_BODY_ID)) setConstraintBody((String)value);
		else super.set(id, value);
	}

	public String getDescription() {
		return getConstraintName()+": "+getConstraintBody();
	}

	public void show() {
		if(getConstraintType()==null) System.out.println("constraint type: null");
		else System.out.println("constraint name: "+getConstraintType());
		if(getConstraintName()==null) System.out.println("constraint name: null");
		else System.out.println("constraint name: "+getConstraintName());
		if(getConstraintBody()==null) System.out.println("constraint body: null");
		else System.out.println("constraint body: "+getConstraintBody());
		super.show();
	}

	public ConstraintResponsibility() {
		super();
		setName("Constraint");
	}

	public ConstraintResponsibility(String modelElement, String modelElementName, String constraintType, String constraintName, String constraintBody) {
		super("Constraint", modelElement, modelElementName);
		setConstraintType(constraintType);
		setConstraintName(constraintName);
		setConstraintBody(constraintBody);
	}
}
