package org.andromda.cartridges.arc;

import java.util.Collection;
import java.util.Iterator;

/**
 * DBSchema Treatment Class
 */
public class DBSchemaTreatment extends Treatment {
	public DBSchemaTreatment(Responsibility resp) {
		super("DBSchema", "Persistence", resp);
	}
	public String getDescription() {
		String desc="";
		if(resp instanceof KeyResponsibility) {
			desc="The database schema could have 'Primary Keys' and 'Unique' constraints to ensure the key responsibility.";
		}
		else if(resp instanceof CardinalityResponsibility) {
			desc="The database schema could have 'Checks' to ensure the cardinality responsibility.";
		}
		return desc;
	}
}
