package org.andromda.cartridges.arc;

import java.util.Collection;
import java.util.Iterator;

/**
 * Dictionary Treatment Class
 */
public class DictionaryTreatment extends Treatment {
	public DictionaryTreatment(Responsibility resp) {
		super("Dictionary", "Domain", resp);
	}
	public String getDescription() {
		String desc="";
		if(resp instanceof KeyResponsibility) {
			desc="A dictionary can be used to determine if a key is valid.";
		}
		else if(resp instanceof CardinalityResponsibility) {
			desc="One dictionary for the class '"+((CardinalityResponsibility)resp).getElementClassName()+"' can be used to count the number of instances associated with the class'"+((CardinalityResponsibility)resp).getModelElementName()+"'.";
		}
		else if(resp instanceof ConstraintResponsibility) {
			desc="The constraint can be handled using a dictionary in the domain layer.";
		}
		return desc;
	}
}
