package org.andromda.cartridges.arc;

import java.util.Collection;
import java.util.Iterator;

/**
 * Hybernate Treatment Class
 */
public class HybernateTreatment extends Treatment {
	public HybernateTreatment(Responsibility resp) {
		super("Hybernate", "Persistence", resp);
	}
	public String getDescription() {
		String desc="";
		if(resp instanceof KeyResponsibility) {
			desc="Hybernate can handle the responsibility of checking Keys.";
		}
		else if(resp instanceof CardinalityResponsibility) {
			desc="Hybernate can be asked for the cardinality of some relation.";
		}
		else if(resp instanceof ConstraintResponsibility) {
			desc="The constraint can be handled using a Hybernate in the persistence layer.";
		}
		return desc;
	}
}
