package org.andromda.cartridges.arc;

import java.util.Collection;
import java.util.Iterator;

/**
 * InputSizeControl Treatment Class
 */
public class InputSizeControlTreatment extends Treatment {
	public InputSizeControlTreatment(Responsibility resp) {
		super("InputSizeControl", "Presentation", resp);
	}
	public String getDescription() {
		String desc="";
		if(resp instanceof CardinalityResponsibility) {
			desc="The user can be limited to select ";
			if(((CardinalityResponsibility)resp).getLower().intValue() == ((CardinalityResponsibility)resp).getUpper().intValue()) desc+=((CardinalityResponsibility)resp).getUpper();
			else {
				if(((CardinalityResponsibility)resp).getLower().intValue() != 0) desc+="at least "+((CardinalityResponsibility)resp).getLower();
				if(((CardinalityResponsibility)resp).getLower().intValue() != 0 && ((CardinalityResponsibility)resp).getUpper().intValue() != -1) desc+=" and ";
				if(((CardinalityResponsibility)resp).getUpper().intValue() != -1) desc+="at the most "+((CardinalityResponsibility)resp).getUpper();
			}
			desc+=" '"+((CardinalityResponsibility)resp).getElementClassName()+"'.";
		}
		return desc;
	}
}
