package org.andromda.cartridges.arc;

import java.util.Collection;
import java.util.Iterator;

/**
 * Key Responsibility Class
 */
public class KeyResponsibility extends Responsibility {
	public static final String KEY_ID="Key";
	public static final String ALTERNATIVE_KEY_ID="AlternativeKey";

	private Collection key;
	private Collection alternativeKey;

	public Collection getKey() { return key; }
	public Collection getAlternativeKey() { return alternativeKey; }

	public void setKey(Collection key) { this.key=key; }
	public void setAlternativeKey(Collection alternativeKey) { this.alternativeKey=alternativeKey; }

	public Object get(String id) {
		if(id.equals(KEY_ID)) return getKey();
		else if(id.equals(ALTERNATIVE_KEY_ID)) return getAlternativeKey();
		else return super.get(id);
	}

	public void set(String id, Object value) { 
		if(id.equals(KEY_ID)) setKey((Collection)value);
		else if(id.equals(ALTERNATIVE_KEY_ID)) setAlternativeKey((Collection)value);
		else super.set(id, value);
	}

	public String getDescription() {
		String description=null;
		description="Key { ";
		Iterator key_iter=getKey().iterator();
		while(key_iter.hasNext()) description+=key_iter.next()+", ";
		description=description.substring(0, description.length()-2)+" }";
		if(!alternativeKey.isEmpty()) {
			description+=" Alternative Key { ";
			key_iter=getAlternativeKey().iterator();
			while(key_iter.hasNext()) description+=key_iter.next()+", ";
			description=description.substring(0, description.length()-2)+" }";
		}
		return description;
	}


	public void show() {
		String tmp;
		Iterator key_iter;
		if(getKey()==null) System.out.println("key: null");
		else if(getKey().isEmpty()) System.out.println("alternative key: empty");
		else {
			tmp="key: ";
			key_iter=getKey().iterator();
			while(key_iter.hasNext()) tmp+=key_iter.next()+", ";
			tmp=tmp.substring(0, tmp.length()-2);
			System.out.println(tmp);
		}
		if(getAlternativeKey()==null) System.out.println("alternative key: null");
		else if(getAlternativeKey().isEmpty()) System.out.println("alternative key: empty");
		else {
			tmp="alternative key: ";
			key_iter=getAlternativeKey().iterator();
			while(key_iter.hasNext()) tmp+=key_iter.next()+", ";
			tmp=tmp.substring(0, tmp.length()-2);
			System.out.println(tmp);
		}
		super.show();
	}

	public KeyResponsibility() {
		setName("Key");
		setModelElement("Class");
	}

	public KeyResponsibility(String modelElementName, Collection key, Collection alternativeKey) {
		super("Key", "Class", modelElementName);
		setKey(key);
		setAlternativeKey(alternativeKey);
	}
}
