package org.andromda.cartridges.arc;

/**
 * Responsibility Abstract Class
 */
public abstract class Responsibility {
	public static final String NAME_ID="Name";
	public static final String MODEL_ELEMENT_ID="ModelElement";
	public static final String MODEL_ELEMENT_NAME_ID="ModelElementName";
	public static final String DESCRIPTION_ID="Description";

	private String name="";
	private String modelElement="";
	private String modelElementName="";

	public String getName() { return name; }
	public String getModelElement() { return modelElement; }
	public String getModelElementName() { return modelElementName; }

	public void setName(String name) { this.name=name; }
	public void setModelElement(String modelElement) { this.modelElement=modelElement; }
	public void setModelElementName(String modelElementName) { this.modelElementName=modelElementName; }

	public Object get(String id) {
		if(id.equals(NAME_ID)) return getName();
		else if(id.equals(MODEL_ELEMENT_ID)) return getModelElement();
		else if(id.equals(MODEL_ELEMENT_NAME_ID)) return getModelElementName();
		else if(id.equals(DESCRIPTION_ID)) return getDescription();
		else return null;
	}

	public void set(String id, Object value) {
		if(id.equals(NAME_ID)) setName((String)value);
		else if(id.equals(MODEL_ELEMENT_ID)) setModelElement((String)value);
		else if(id.equals(MODEL_ELEMENT_NAME_ID)) setModelElementName((String)value);
		else return;
	}

	public abstract String getDescription();

	public void show() {
		if(getName()==null) System.out.println("name: null");
		else System.out.println("name: "+getName());
		if(getModelElement()==null) System.out.println("model element: null");
		else System.out.println("model element: "+getModelElement());
		if(getModelElementName()==null) System.out.println("model element name: null");
		else System.out.println("model element name: "+getModelElementName());
		if(getDescription()==null) System.out.println("description: null");
		else System.out.println("description: "+getDescription());
	}

	Responsibility() {}
	Responsibility(String name, String modelElement, String modelElementName) {
		setName(name);
		setModelElement(modelElement);
		setModelElementName(modelElementName);
	}
}
