package org.andromda.cartridges.arc;

import java.util.Collection;
import java.util.ArrayList;

/**
 * Responsibility Processor
 */
public class ResponsibilityProcessor {
	private String tecnologicDependency;
	private String developLanguage;
	private String database;
	private String interfaceComplexity;

	public void setPreferences(String tecnologicDependency, String developLanguage, String database, String interfaceComplexity) {
		if(tecnologicDependency==null) this.tecnologicDependency="";
		else this.tecnologicDependency=tecnologicDependency;
		if(developLanguage==null) this.developLanguage="";
		else this.developLanguage=developLanguage;
		if(database==null) this.database="";
		else this.database=database;
		if(database==null) this.interfaceComplexity="";
		else this.interfaceComplexity=interfaceComplexity;
	}

	public Collection process(Responsibility resp) {
		ArrayList Treatments=new ArrayList();
	
		if(resp instanceof KeyResponsibility) {
			Treatments.add(new DictionaryTreatment(resp));
			if((tecnologicDependency.equals("High")) && (developLanguage.equals("Java") || developLanguage.equals(".NET")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new HybernateTreatment(resp));
			if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new SQLTreatment(resp));
			if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new DBSchemaTreatment(resp));
		}
		else if(resp instanceof CardinalityResponsibility) {
			Treatments.add(new CardinalityControlTreatment(resp));
			if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (interfaceComplexity.equals("Medium") || interfaceComplexity.equals("High"))) Treatments.add(new InputSizeControlTreatment(resp));
			if((tecnologicDependency.equals("High")) && (developLanguage.equals("Java") || developLanguage.equals(".NET")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new HybernateTreatment(resp));
			if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new SQLTreatment(resp));
			if((tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new TriggerTreatment(resp));
			if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new DBSchemaTreatment(resp));
		}
		else if(resp instanceof ConstraintResponsibility) {
			if(((ConstraintResponsibility)resp).getConstraintName().equals("existsElement")) {
				Treatments.add(new DictionaryTreatment(resp));
				if((tecnologicDependency.equals("High")) && (developLanguage.equals("Java") || developLanguage.equals(".NET")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new HybernateTreatment(resp));
				if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new SQLTreatment(resp));
				if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (interfaceComplexity.equals("High"))) Treatments.add(new InputFilterTreatment(resp));
			}
			if(((ConstraintResponsibility)resp).getConstraintName().equals("notEmptyPopulation")) {
				Treatments.add(new DictionaryTreatment(resp));
				if((tecnologicDependency.equals("High")) && (developLanguage.equals("Java") || developLanguage.equals(".NET")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new HybernateTreatment(resp));
				if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new SQLTreatment(resp));
			}
			if(((ConstraintResponsibility)resp).getConstraintName().equals("deleteElement")) {
				Treatments.add(new DictionaryTreatment(resp));
				if((tecnologicDependency.equals("High")) && (developLanguage.equals("Java") || developLanguage.equals(".NET")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new HybernateTreatment(resp));
				if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new SQLTreatment(resp));
				if((tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new StoredProcedureTreatment(resp));
				if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new OnCascadeTreatment(resp));
			}
			if(((ConstraintResponsibility)resp).getConstraintName().equals("insertElement")) {
				Treatments.add(new DictionaryTreatment(resp));
				if((tecnologicDependency.equals("High")) && (developLanguage.equals("Java") || developLanguage.equals(".NET")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new HybernateTreatment(resp));
				if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new SQLTreatment(resp));
				if((tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new StoredProcedureTreatment(resp));
			}
			if(((ConstraintResponsibility)resp).getConstraintName().equals("listAll")) {
				Treatments.add(new DictionaryTreatment(resp));
				if((tecnologicDependency.equals("High")) && (developLanguage.equals("Java") || developLanguage.equals(".NET")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new HybernateTreatment(resp));
				if((tecnologicDependency.equals("Medium") || tecnologicDependency.equals("High")) && (database.equals("Oracle") || database.equals("PostgreSQL"))) Treatments.add(new SQLTreatment(resp));
			}
		}
		return Treatments;
	}
}
