package org.andromda.cartridges.arc;

import java.util.Collection;
import java.util.Iterator;

/**
 * StoredProcedure Treatment Class
 */
public class StoredProcedureTreatment extends Treatment {
	public StoredProcedureTreatment(Responsibility resp) {
		super("StoredProcedure", "Persistence", resp);
	}
	public String getDescription() {
		String desc="";
		if(resp instanceof ConstraintResponsibility) {
			if(((ConstraintResponsibility)resp).getConstraintName().equals("deleteElement")) {
				desc="The database can delete an element using stored procedures.";
			}
			if(((ConstraintResponsibility)resp).getConstraintName().equals("insertElement")) {
				desc="The database can insert an element using stored procedures.";
			}
			if(((ConstraintResponsibility)resp).getConstraintName().equals("listAll")) {
				desc="The database can list elements using stored procedures.";
			}
		}
		return desc;
	}
}
