package org.andromda.cartridges.arc;

/**
 * Treatment Class
 */
public abstract class Treatment {
	public static final String NAME_ID="Name";
	public static final String LAYER_ID="Layer";
	public static final String DESCRIPTION_ID="Description";

	private String name="";
	private String layer="";
	protected Responsibility resp=null;

	public String getName() { return name; }
	public String getLayer() { return layer; }
	public abstract String getDescription();

	public void setName(String name) { this.name=name; }
	public void setLayer(String layer) { this.layer=layer; }

	public String get(String id) {
		if(id.equals(NAME_ID)) return getName();
		else if(id.equals(LAYER_ID)) return getLayer();
		else if(id.equals(DESCRIPTION_ID)) return getDescription();
		else return null;
	}

	public void set(String id, Object value) {
		if(id.equals(NAME_ID)) setName((String)value);
		else if(id.equals(LAYER_ID)) setLayer((String)value);
		else return;
	}

	public void show() {
		if(getName()==null) System.out.println("null");
		else System.out.println(getName());
		if(getLayer()==null) System.out.println("null");
		else System.out.println(getLayer());
		if(getDescription()==null) System.out.println("null");
		else System.out.println(getDescription());
	}

	public Treatment() {
	}

	public Treatment(String name, String layer, Responsibility resp) {
		this.resp=resp;
		setName(name);
		setLayer(layer);
	}

}
