package org.andromda.cartridges.arc.metafacades;

import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.cartridges.arc.Debug;
import org.andromda.cartridges.arc.Responsibility;
import org.andromda.cartridges.arc.KeyResponsibility;
import org.andromda.cartridges.arc.CardinalityResponsibility;
import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;

/**
* MetafacadeLogic implementation for org.andromda.cartridges.arc.metafacades.ARC_ClassifierFacade.
*
* @see org.andromda.cartridges.arc.metafacades.ARC_ClassifierFacade
*/
public class ARC_ClassifierFacadeLogicImpl
extends ARC_ClassifierFacadeLogic
{

	public ARC_ClassifierFacadeLogicImpl (Object metaObject, String context)
	{
		super (metaObject, context);
	}
	
	/**
	* @see org.andromda.cartridges.arc.metafacades.ARC_ClassifierFacade#getResponsibilities()
	*/
	protected java.util.Collection handleGetResponsibilities()
	{
		ArrayList Responsibilities=new ArrayList();
	
		Responsibility resp=keyResponsibility();
		if(resp!=null) Responsibilities.add(resp);
	
		Responsibilities.addAll(cardinalityResponsibilities());

		/**DEBUG INFO- REMOVE ON RELEASE**/
		//Debug dbg=new Debug();
		//dbg.printResponsibilities(Responsibilities);
		
		return Responsibilities;
	}
	
	/**
	* @see org.andromda.cartridges.arc.metafacades.ARC_ClassifierFacade#getResponsibility(java.lang.String)
	*/
	protected Responsibility handleGetResponsibility(java.lang.String name)
	{
		Iterator iter=handleGetResponsibilities().iterator();
		while(iter.hasNext()) {
			Responsibility resp=(Responsibility)iter.next();
			if(resp.getName().equals(name)) return resp;
		}
		return null;
	}
	
	
	/**
	* Key Responsibility
	*/
	protected Responsibility keyResponsibility()
	{
		Collection keyColl=getKey();
		if(keyColl.isEmpty()) return null;
	
		return new KeyResponsibility(getName(), keyStrings(keyColl), keyStrings(getAlternativeKey()));
	}
	
	/**
	* KeyStrings
	*/
	protected Collection keyStrings(Collection key)
	{
		ArrayList coll=new ArrayList();
		Iterator key_iter=key.iterator();
		while(key_iter.hasNext()) {
			AttributeFacade atr=(AttributeFacade)key_iter.next();
			if(!atr.getOwner().equals(this)) coll.add(atr.getOwner().getName()+"."+atr.getName());
			else coll.add(atr.getName());
		}
		return coll;
	}
	
	/**
	* Get Key
	* pre: solo puede existir Key o WeakKey (uno o otro).
	* pre: hay una y solo uan asociacion many2one y composite.
	* pre: Todas las clases tiene el metafacade ARC
	*/
	protected Collection getKey()
	{
		boolean weak=false;
		ArrayList coll=new ArrayList();
		Iterator attr_iter=getAttributes().iterator();
		while(attr_iter.hasNext()) {
			AttributeFacade atr=(AttributeFacade)attr_iter.next();
			if(atr.hasStereotype("Key")) coll.add(atr);
			if(atr.hasStereotype("WeakKey")) {
				coll.add(atr);
				weak=true;
			}
		}
		if(weak) {
			Iterator end_iter=getAssociationEnds().iterator();
			while(end_iter.hasNext()) {
				AssociationEndFacade asso=(AssociationEndFacade)end_iter.next();
				ARC_ClassifierFacadeLogicImpl target=(ARC_ClassifierFacadeLogicImpl)asso.getOtherEnd().getType();
				if (asso.isMany2One() && asso.getOtherEnd().isComposition()) coll.addAll(target.getKey());
			}
		}
		return coll;
	}
	
	/**
	* Get Alternative Key
	*/
	protected Collection getAlternativeKey()
	{
		ArrayList coll=new ArrayList();
		Iterator attr_iter=getAttributes().iterator();
		while(attr_iter.hasNext()) {
			AttributeFacade atr=(AttributeFacade)attr_iter.next();
			if(atr.hasStereotype("AlternativeKey")) coll.add(atr);
		}
		return coll;
	}
	
	/**
	* Check Cicles of weak keys
	* pre: solo puede existir Key o WeakKey (uno o otro).
	* pre: hay una y solo uan asociacion many2one y composite.
	*/
	public void validateInvariants(java.util.Collection validationMessages)
	{
		super.validateInvariants(validationMessages);

		boolean cicle_detected=false;
		if(haveWeak()) {
			ARC_ClassifierFacadeLogicImpl currentClass=this, prevClass=null;
			do {
				Iterator end_iter=currentClass.getAssociationEnds().iterator();
				while(end_iter.hasNext()) {
					AssociationEndFacade asso=(AssociationEndFacade)end_iter.next();
					if (asso.isMany2One() && asso.getOtherEnd().isComposition())
						prevClass=currentClass;
						currentClass=(ARC_ClassifierFacadeLogicImpl)asso.getOtherEnd().getType();
						if(currentClass==prevClass) cicle_detected=true;
						else if(getName().equals(currentClass.getName())) cicle_detected=true;
				}
			} while(currentClass.haveWeak() && !cicle_detected);
	
			if (cicle_detected) validationMessages.add(
				new org.andromda.core.metafacade.ModelValidationMessage(this, "org::andromda::cartridges::arc::metafacades::ARC_ClassifierFacade::WeakKey Cicle Check", "You can NOT set a cicle of weak classes."));
		}
	}

	/**
	* haveWeak
	*/
	protected boolean haveWeak()
	{
		boolean weak=false;
		Iterator attr_iter=getAttributes().iterator();
		while(attr_iter.hasNext() && !weak) {
			AttributeFacade atr=(AttributeFacade)attr_iter.next();
			if(atr.hasStereotype("WeakKey")) weak=true;
		}
		return weak;
	}

	/**
	* Cardinality Responsibilities
	*/
	protected java.util.Collection cardinalityResponsibilities()
	{
		ArrayList Responsibilities=new ArrayList();
		Iterator end_iter=getAssociationEnds().iterator();
		while(end_iter.hasNext()) {
			Responsibility resp=cardinalityResponsibility(((AssociationEndFacade)end_iter.next()).getOtherEnd());
			if(resp!=null) Responsibilities.add(resp);
		}
		return Responsibilities;
	}

	/**
	* Cardinality Responsibility
	*/
	protected Responsibility cardinalityResponsibility(AssociationEndFacade assoc_end)
	{
		if(assoc_end.getUpper() == -1 && assoc_end.getLower() <= 0) return null;
		return new CardinalityResponsibility("Class", getName(), "Association", new Integer(assoc_end.getLower()), new Integer(assoc_end.getUpper()), assoc_end.getType().getName());
	}
}