package org.andromda.cartridges.arc.metafacades;

import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ConstraintFacade;
import org.andromda.cartridges.arc.Debug;
import org.andromda.cartridges.arc.Responsibility;
import org.andromda.cartridges.arc.ConstraintResponsibility;
import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;

/**
* MetafacadeLogic implementation for org.andromda.cartridges.arc.metafacades.ARC_OperationFacade.
*
* @see org.andromda.cartridges.arc.metafacades.ARC_OperationFacade
*/
public class ARC_OperationFacadeLogicImpl
extends ARC_OperationFacadeLogic
{
	public ARC_OperationFacadeLogicImpl (Object metaObject, String context)
	{
		super (metaObject, context);
	}
	
	/**
	* @see org.andromda.cartridges.arc.metafacades.ARC_OperationFacade#getResponsibilities()
	*/
	protected java.util.Collection handleGetResponsibilities()
	{
		ArrayList Responsibilities=new ArrayList();
	
		Responsibilities.addAll(contraintResponsibilities());
	
		/**DEBUG INFO- REMOVE ON RELEASE**/
		//Debug dbg=new Debug();
		//dbg.printResponsibilities(Responsibilities);
		
		return Responsibilities;
	}
	
	/**
	* @see org.andromda.cartridges.arc.metafacades.ARC_OperationFacade#getResponsibility(java.lang.String)
	*/
	protected org.andromda.cartridges.arc.Responsibility handleGetResponsibility(java.lang.String name)
	{
		Iterator iter=handleGetResponsibilities().iterator();
		while(iter.hasNext()) {
			Responsibility resp=(Responsibility)iter.next();
			if(resp.getName().equals(name)) return resp;
		}
		return null;
	}
	
	/**
	* Contraint Responsibilities
	*/
	protected java.util.Collection contraintResponsibilities()
	{
		ArrayList Responsibilities=new ArrayList();
		Iterator constr_iter=getConstraints().iterator();
		while(constr_iter.hasNext()) {
			Responsibility resp=contraintResponsibility((ConstraintFacade)constr_iter.next());
			if(resp!=null) Responsibilities.add(resp);
		}
		return Responsibilities;
	}
	
	/**
	* Constraint Responsibility
	*/
	protected Responsibility contraintResponsibility(ConstraintFacade constr)
	{
		// Only pre and post
		if(!(constr.isPreCondition() || constr.isPostCondition())) return null;
		// not at the same time
		if(constr.isPreCondition() && constr.isPostCondition()) return null;
		// No context or what ever
		if(!(constr.getBody().startsWith("pre:") || constr.getBody().startsWith("post:"))) return null;
		// must be one of the following
		if(!(constr.getName().startsWith("existsElement") || constr.getName().startsWith("notEmptyPopulation") || constr.getName().startsWith("deleteElement") || constr.getName().startsWith("insertElement") || constr.getName().startsWith("listAll"))) return null;
		// these ones can only be postconditions
		if((constr.getName().startsWith("deleteElement") || constr.getName().startsWith("insertElement") || constr.getName().startsWith("listAll")) && !constr.isPostCondition()) return null;

		ConstraintResponsibility resp=new ConstraintResponsibility();
		resp.setModelElement("Operation");
		resp.setModelElementName(getOwner().getName()+"."+getName());
		if(constr.isPreCondition()) resp.setConstraintType("Precondition");
		else if(constr.isPostCondition()) resp.setConstraintType("Postcondition");
		resp.setConstraintName(constr.getName());
		resp.setConstraintBody(constr.getBody());
		return resp;
	}
}