<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<html>
			<body>
				<h1>ARC Cartridge Results</h1>
				<h3>Current user preferences</h3>
				<table border="0">
					<tr bgcolor="#9acd32">
						<th align="left">Preference</th>
						<th align="left">Value</th>
					</tr>
					<tr>
						<td>tecnologicDependency</td>
						<td><xsl:value-of select="responsibilities/preferences/tecnologicDependency"/></td>
					</tr>
					<tr>
						<td>developLanguage</td>
						<td><xsl:value-of select="responsibilities/preferences/developLanguage"/></td>
					</tr>
					<tr>
						<td>database</td>
						<td><xsl:value-of select="responsibilities/preferences/database"/></td>
					</tr>
					<tr>
						<td>interfaceComplexity</td>
						<td><xsl:value-of select="responsibilities/preferences/interfaceComplexity"/></td>
					</tr>
				</table>
				<h3>Responsibilities list</h3>
				<table border="0">
					<tr bgcolor="#9acd32">
						<th align="left">Responsibility</th>
						<th align="left">Model Element</th>
						<th align="left">Model Element Name</th>
						<th align="left">Responsibility description</th>
					</tr>
					<xsl:for-each select="responsibilities/responsibility">
						<tr>
							<td><a href="#{generate-id(name)}"><xsl:value-of select="name"/></a></td>
							<td><xsl:value-of select="modelElement"/></td>
							<td><xsl:value-of select="modelElementName"/></td>
							<td><xsl:value-of select="description"/></td>
						</tr>
					</xsl:for-each>
				</table>
				<xsl:for-each select="responsibilities/responsibility">
					<a name="{generate-id(name)}"><h3><xsl:value-of select="modelElementName"/>: <xsl:value-of select="description"/></h3><table border="0">
							<tr bgcolor="#9acd32">
								<th align="left">Treatment</th>
								<th align="left">Layer/Tier</th>
								<th align="left">Treatment description</th>
							</tr>
							<xsl:for-each select="treatment">
								<tr>
									<td><xsl:value-of select="name"/></td>
									<td><xsl:value-of select="layer"/></td>
									<td><xsl:value-of select="description"/></td>
								</tr>
							</xsl:for-each>
						</table></a>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
