/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateController {
    private static SessionFactory sessionFactory = null;

    public static void initialize(boolean create, String path) {
        if (sessionFactory == null) {
            HibernateController.buildSession(HibernateController.buildConfiguration(create, path));
        }
    }

    private static Configuration buildConfiguration(boolean create, String path) {
        Configuration cfg = new Configuration();
        cfg.configure("hibernate.cfg.xml");
        if (create) {
            cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        }
        cfg.setProperty("hibernate.connection.url", "jdbc:h2:" + path + "/ATDataBase;create=true");
        return cfg;
    }

    private static void buildSession(Configuration cfg) {
        sessionFactory = cfg.buildSessionFactory();
    }

    public static Session getSession() {
        return sessionFactory.getCurrentSession();
    }

    public static void openSession() {
        sessionFactory.openSession();
    }

    public static void closeSession() {
        Session s = HibernateController.getSession();
        if (s != null && s.isOpen()) {
            s.close();
        }
    }

    public static void beginTransaction() {
        HibernateController.getSession().beginTransaction();
    }

    public static void commitTransaction() {
        HibernateController.getSession().getTransaction().commit();
    }

    public static void rollback() {
        try {
            HibernateController.getSession().getTransaction().rollback();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
    }
}

