/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domainModel.decision;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domainModel.decisionRule.DecisionRule;
import upc.gessi.architech.hibernatehelper.domainModel.element.Element;

public class Decision {
    private Long id;
    private String name;
    private String description;
    private Set<DecisionRule> decisionRules;
    private Set<Element> elements;

    public Decision() {
        this.elements = new HashSet<Element>();
        this.decisionRules = new HashSet<DecisionRule>();
    }

    public Decision(String n) {
        this.name = n;
        this.elements = new HashSet<Element>();
        this.decisionRules = new HashSet<DecisionRule>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Set<DecisionRule> getDecisionRules() {
        return this.decisionRules;
    }

    public void setDecisionRules(Set<DecisionRule> dr) {
        this.decisionRules = dr;
    }

    public void addDecisionRule(DecisionRule dr) {
        this.decisionRules.add(dr);
        dr.setDecision(this);
    }

    public void removeAllRules() {
        this.decisionRules.clear();
    }

    public Set<Element> getElements() {
        return this.elements;
    }

    public void setElements(Set<Element> e) {
        this.elements = e;
    }

    public void addElement(Element e) {
        this.elements.add(e);
        e.addDecision(this);
    }

    public void clearElements() {
        this.elements.clear();
    }

    public boolean equals(Object d) {
        if (!(d instanceof Decision)) {
            return false;
        }
        return this.id.equals(((Decision)d).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() {
        for (DecisionRule dr : this.decisionRules) {
            dr.remove();
        }
        this.decisionRules.clear();
        for (Element e : this.elements) {
            e.removeDecision(this);
        }
        this.elements.clear();
    }
}

