/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domainModel.property;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domainModel.decisionRule.drPropertyCondition;
import upc.gessi.architech.hibernatehelper.domainModel.property.Requirement;
import upc.gessi.architech.hibernatehelper.domainModel.propertyRule.PropertyRule;
import upc.gessi.architech.hibernatehelper.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;

public class Property {
    private Long id;
    private String name;
    private String description;
    private Requirement requirement;
    private DataType type;
    private Set<PropertyRule> propertyRules;
    private Set<drPropertyCondition> propertyConditions;

    public Property() {
        this.requirement = null;
        this.propertyRules = new HashSet<PropertyRule>();
        this.propertyConditions = new HashSet<drPropertyCondition>();
    }

    public Property(String n, DataType t) {
        this.name = n;
        this.type = t;
        this.requirement = null;
        this.propertyRules = new HashSet<PropertyRule>();
        this.propertyConditions = new HashSet<drPropertyCondition>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public void setRequirement(Requirement req) {
        this.requirement = req;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType t) {
        this.type = t;
    }

    public Set<PropertyRule> getPropertyRules() {
        return this.propertyRules;
    }

    public void setPropertyRules(Set<PropertyRule> pr) {
        this.propertyRules = pr;
    }

    public void addPropertyRule(PropertyRule pr) {
        this.propertyRules.add(pr);
        pr.setProperty(this);
    }

    public Set<drPropertyCondition> getPropertyConditions() {
        return this.propertyConditions;
    }

    public void setPropertyConditions(Set<drPropertyCondition> pc) {
        this.propertyConditions = pc;
    }

    public void addPropertyCondition(drPropertyCondition drp) {
        this.propertyConditions.add(drp);
    }

    public void removePropertyCondition(drPropertyCondition pr) {
        this.propertyConditions.remove(pr);
    }

    public boolean equals(Object p) {
        if (!(p instanceof Property)) {
            return false;
        }
        return this.id.equals(((Property)p).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() throws DomainException {
        if (!this.propertyConditions.isEmpty()) {
            throw new DomainException("This property forms part of one of the rules of a Decision.\nIt can't be removed");
        }
        this.type.removeProperty(this);
        Set<PropertyRule> rules = this.getPropertyRules();
        for (PropertyRule pr : rules) {
            pr.remove();
        }
        this.propertyRules.clear();
    }

    public void removeAllRules() {
        this.propertyRules.clear();
    }
}

