/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domainModel.question;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domainModel.propertyRule.prQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domainModel.questionRule.QuestionRule;
import upc.gessi.architech.hibernatehelper.domainModel.questionRule.qrQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;

public class Question {
    private Long id;
    private String text;
    private int order;
    private Set<QuestionRule> questionRules = new HashSet<QuestionRule>();
    private Set<qrQuestionRestriction> questionRestrictions = new HashSet<qrQuestionRestriction>();
    private Set<prQuestionRestriction> propertyRestrictions = new HashSet<prQuestionRestriction>();
    private DataType questionType;

    public Question() {
    }

    public Question(DataType t) {
        this.questionType = t;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int o) {
        this.order = o;
    }

    public Set<QuestionRule> getQuestionRules() {
        return this.questionRules;
    }

    public void setQuestionRules(Set<QuestionRule> qr) {
        this.questionRules = qr;
    }

    public Set<qrQuestionRestriction> getQuestionRestrictions() {
        return this.questionRestrictions;
    }

    public void setQuestionRestrictions(Set<qrQuestionRestriction> qr) {
        this.questionRestrictions = qr;
    }

    public void removeRestriction(qrQuestionRestriction qrq) {
        this.questionRestrictions.remove(qrq);
    }

    public Set<prQuestionRestriction> getPropertyRestrictions() {
        return this.propertyRestrictions;
    }

    public void setPropertyRestrictions(Set<prQuestionRestriction> pr) {
        this.propertyRestrictions = pr;
    }

    public void removeRestriction(prQuestionRestriction prq) {
        this.propertyRestrictions.remove(prq);
    }

    public DataType getQuestionType() {
        return this.questionType;
    }

    public void setQuestionType(DataType t) {
        this.questionType = t;
    }

    public void addQuestionRule(QuestionRule qr) {
        this.questionRules.add(qr);
        qr.setQuestion(this);
    }

    public void addQuestionRestriction(qrQuestionRestriction qrq) {
        this.questionRestrictions.add(qrq);
    }

    public void addPropertyRestriction(prQuestionRestriction prq) {
        this.propertyRestrictions.add(prq);
    }

    public boolean appearInRules(Question q) {
        for (QuestionRule qr : this.questionRules) {
            if (!qr.appearIn(q)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object q) {
        if (!(q instanceof Question)) {
            return false;
        }
        return this.id.equals(((Question)q).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() throws DomainException {
        if (!this.questionRestrictions.isEmpty() || !this.propertyRestrictions.isEmpty()) {
            throw new DomainException("The Question you want to remove is being usedby a Property or another Question.\nIt can't be removed");
        }
        this.questionType.removeQuestion(this);
        Set<QuestionRule> rules = this.getQuestionRules();
        for (QuestionRule qr : rules) {
            qr.remove();
        }
        this.questionRules.clear();
    }

    public void removeAllRules() {
        this.questionRules.clear();
    }
}

