/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domainModel.type;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domainModel.property.Property;
import upc.gessi.architech.hibernatehelper.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;

public abstract class DataType {
    private Long id;
    private String name;
    private String description;
    private Set<Question> questions;
    private Set<Property> properties;

    public DataType() {
        this.questions = new HashSet<Question>();
        this.properties = new HashSet<Property>();
    }

    public DataType(String n) {
        this.name = n;
        this.questions = new HashSet<Question>();
        this.properties = new HashSet<Property>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long i) {
        this.id = i;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Set<Question> getQuestions() {
        return this.questions;
    }

    public void setQuestions(Set<Question> qs) {
        this.questions = qs;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> ps) {
        this.properties = ps;
    }

    public void removeQuestion(Question q) {
        this.questions.remove(q);
    }

    public void removeProperty(Property p) {
        this.properties.remove(p);
    }

    public void addQuestion(Question q) {
        this.questions.add(q);
        q.setQuestionType(this);
    }

    public void addProperty(Property p) {
        this.properties.add(p);
        p.setType(this);
    }

    public boolean equals(Object t) {
        if (!(t instanceof DataType)) {
            return false;
        }
        return ((DataType)t).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() throws DomainException {
        if (!this.questions.isEmpty() || !this.properties.isEmpty()) {
            throw new DomainException("A Question or a Property uses that Type.\nIt can't be removed");
        }
    }

    public abstract String getIconPath();
}

