/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.HibernateController;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "upc.gessi.ArchiTech";
    private static Activator plugin;
    private Shell shell;
    private IPreferenceStore prefs;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.shell = this.getWorkbench().getDisplay().getActiveShell();
        this.prefs = this.getPreferenceStore();
        boolean create = false;
        if (!this.prefs.getBoolean("dont_show_create")) {
            create = this.askCreateDB();
        }
        try {
            HibernateController.initialize((boolean)create, (String)this.prefs.getString("db_path"));
            System.out.println("Hibernate inicialitzat correctament!");
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "There are some problmes with the DataBase.", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        String iconPath = "icons/";
        try {
            URL installURL = Activator.getDefault().getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + name);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private boolean askCreateDB() {
        MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)this.shell, (String)"DataBase Creation", (String)"Do you want to create and use a new DataBase?", (String)"Don't show this message again", (boolean)false, (IPreferenceStore)this.prefs, (String)"dont_show_create");
        this.prefs.setValue("dont_show_create", m.getToggleState());
        if (m.getReturnCode() == 2) {
            DirectoryDialog dd = new DirectoryDialog(this.shell, 8192);
            dd.setText("New Database");
            dd.setMessage("Select the location to store the DataBase files");
            String db_path = dd.open();
            if (db_path != null) {
                this.prefs.setValue("db_path", db_path);
                return true;
            }
        }
        return false;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        this.prefs.setDefault("dont_show_create", false);
        this.prefs.setDefault("db_path", "~/database");
    }
}

