/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.domain.controller;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import upc.gessi.architech.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.HibernateController;
import upc.gessi.architech.hibernatehelper.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domainModel.decisionRule.DecisionRule;
import upc.gessi.architech.hibernatehelper.domainModel.decisionRule.drPropertyCondition;
import upc.gessi.architech.hibernatehelper.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domainModel.property.Property;
import upc.gessi.architech.hibernatehelper.domainModel.property.Requirement;
import upc.gessi.architech.hibernatehelper.domainModel.propertyRule.PropertyRule;
import upc.gessi.architech.hibernatehelper.domainModel.propertyRule.prQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domainModel.questionRule.QuestionRule;
import upc.gessi.architech.hibernatehelper.domainModel.questionRule.qrQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.domainModel.type.IntegerType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.persistence.decision.DecisionDAO;
import upc.gessi.architech.persistence.element.ElementDAO;
import upc.gessi.architech.persistence.property.PropertyDAO;
import upc.gessi.architech.persistence.property.RequirementDAO;
import upc.gessi.architech.persistence.question.QuestionDAO;
import upc.gessi.architech.persistence.type.DataTypeDAO;
import upc.gessi.architech.persistence.type.IntegerTypeDAO;
import upc.gessi.architech.utils.TupleDecisionRulesMap;
import upc.gessi.architech.utils.TuplePropertyRulesMap;

public class DomainController {
    private static DomainController controller = null;
    private Requirement notClassifiedRequirement = null;

    private DomainController() {
    }

    public static DomainController getInstance() {
        if (controller == null) {
            controller = new DomainController();
        }
        return controller;
    }

    public HashSet<Question> getAllQuestions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Question> qs = QuestionDAO.getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return qs;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nQuestions cannot be retrieved!", (Throwable)e);
        }
    }

    public HashSet<DataType> getAllTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<DataType> types = new HashSet<DataType>();
            types.addAll(DataTypeDAO.getAll());
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return types;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTypes cannot be retrieved!", (Throwable)e);
        }
    }

    public HashSet<IntegerType> getIntegerTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<IntegerType> itypes = IntegerTypeDAO.getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return itypes;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTypes cannot be retrieved!", (Throwable)e);
        }
    }

    public HashSet<Requirement> getAllRequirements() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Requirement> reqs = RequirementDAO.getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return reqs;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nRequirements cannot be retrieved!", (Throwable)e);
        }
    }

    public HashSet<Property> getAllProperties() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Property> props = PropertyDAO.getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return props;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nProperties cannot be retrieved!", (Throwable)e);
        }
    }

    public HashSet<Element> getAllElements() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Element> es = ElementDAO.getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return es;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nElements cannot be retrieved!", (Throwable)e);
        }
    }

    public HashSet<Decision> getAllDecisions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Decision> ds = DecisionDAO.getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return ds;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nDecisions cannot be retrieved!", (Throwable)e);
        }
    }

    public void remove(Question q) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            q = QuestionDAO.getById(q.getId());
            q.remove();
            int qOrder = q.getOrder();
            HashSet<Question> auxqs = Model.getQuestions();
            HashSet<Question> updateQ = new HashSet<Question>();
            for (Question qaux : auxqs) {
                int auxOrder = qaux.getOrder();
                if (auxOrder <= qOrder) continue;
                updateQ.add(qaux);
            }
            this.updateQuestionsOrder(updateQ, -1);
            QuestionDAO.delete(q);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getQuestions().remove(q);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Question cannot be removed!", (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)e);
        }
    }

    public void remove(Property p) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            p = PropertyDAO.getById(p.getId());
            p.remove();
            Requirement r = p.getRequirement();
            if (r != null) {
                Model.getRequirements().remove(r);
                r = RequirementDAO.getById(r.getId());
                Model.getRequirements().add(r);
                r.removeProperty(p);
                RequirementDAO.update(r);
            } else {
                this.notClassifiedRequirement.removeProperty(p);
            }
            PropertyDAO.delete(p);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getProperties().remove(p);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Property cannot be removed!", (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)e);
        }
    }

    public void remove(Requirement r) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            r = RequirementDAO.getById(r.getId());
            Set props = r.getProperties();
            for (Property p : props) {
                if ((p = PropertyDAO.getById(p.getId())).getPropertyConditions().isEmpty()) continue;
                throw new DomainException("Some of the properties can't be deleted");
            }
            for (Property p : props) {
                p = PropertyDAO.getById(p.getId());
                p.remove();
                PropertyDAO.delete(p);
                Model.getProperties().remove(p);
            }
            r.remove();
            RequirementDAO.delete(r);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getRequirements().remove(r);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Requirement cannot be removed!", (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)e);
        }
    }

    public void remove(Decision d) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            d = DecisionDAO.getById(d.getId());
            Set els = d.getElements();
            for (Element e : els) {
                ElementDAO.lock(e);
            }
            d.remove();
            DecisionDAO.delete(d);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getDecisions().remove(d);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Decision cannot be removed!", (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)e);
        }
    }

    public void remove(DataType dt) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            dt = DataTypeDAO.getById(dt.getId());
            dt.remove();
            DataTypeDAO.delete(dt);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getIntegerTypes().remove((IntegerType)dt);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be removed!", (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)e);
        }
    }

    public void remove(Element e) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            e = ElementDAO.getById(e.getId());
            e.remove();
            ElementDAO.delete(e);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getElements().remove(e);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Element cannot be removed!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public void newQuestion(String typeName, String qText, int qOrder, HashMap<String, HashMap<String, String>> rules) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType type = this.getTypeFromName(typeName);
            DataTypeDAO.lock(type);
            Question q = new Question();
            type.addQuestion(q);
            q.setText(qText);
            q.setOrder(qOrder);
            HashSet<Question> auxqs = Model.getQuestions();
            HashSet<Question> updateQ = new HashSet<Question>();
            for (Question qaux : auxqs) {
                int auxOrder = qaux.getOrder();
                if (auxOrder < qOrder) continue;
                updateQ.add(qaux);
            }
            this.updateQuestionsOrder(updateQ, 1);
            this.newQuestionRules(q, rules);
            QuestionDAO.save(q);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getQuestions().add(q);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Question cannot be created!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public void newProperty(String typeName, String reqName, String name, String description, HashMap<String, TuplePropertyRulesMap> rules) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType type = this.getTypeFromName(typeName);
            Requirement req = null;
            if (reqName != null) {
                req = this.getRequirementFromName(reqName);
            }
            DataTypeDAO.lock(type);
            if (req != null) {
                RequirementDAO.lock(req);
            }
            Property p = new Property();
            p.setName(name);
            if (description != null) {
                p.setDescription(description);
            }
            type.addProperty(p);
            if (req != null) {
                req.addProperty(p);
            }
            this.newPropertyRules(p, rules);
            PropertyDAO.save(p);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getProperties().add(p);
            if (req == null) {
                this.notClassifiedRequirement.getProperties().add(p);
            }
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Property cannot be created!", (Throwable)he);
        }
    }

    public void newRequirement(String name, String description) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Requirement r = new Requirement();
            r.setName(name);
            if (description != null) {
                r.setDescription(description);
            }
            RequirementDAO.save(r);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getRequirements().add(r);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Requirement cannot be created!", (Throwable)he);
        }
    }

    public void newDecision(String name, String desc, HashSet<Element> elements, HashMap<String, TupleDecisionRulesMap> rules) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Decision d = new Decision();
            d.setName(name);
            if (desc != null) {
                d.setDescription(desc);
            }
            for (Element e : elements) {
                e = ElementDAO.getById(e.getId());
                d.addElement(e);
                ElementDAO.update(e);
            }
            this.newDecisionRules(d, rules);
            DecisionDAO.save(d);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getDecisions().add(d);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Decision cannot be created!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public void newElement(String name) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Element e = new Element();
            e.setName(name);
            ElementDAO.save(e);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getElements().add(e);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Element cannot be created!", (Throwable)he);
        }
    }

    public void newIntegerType(String name, String desc, int min, boolean hasMin, int max, boolean hasMax) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            IntegerType type = new IntegerType();
            this.setIntegerTypeValues(type, name, desc, min, hasMin, max, hasMax);
            IntegerTypeDAO.save(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getIntegerTypes().add(type);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Element cannot be created!", (Throwable)he);
        }
    }

    private void setIntegerTypeValues(IntegerType type, String name, String desc, int min, boolean hasMin, int max, boolean hasMax) {
        type.setName(name);
        type.setDescription(desc);
        if (hasMin) {
            type.setMin(new Integer(min));
        } else {
            type.setMin(null);
        }
        if (hasMax) {
            type.setMax(new Integer(max));
        } else {
            type.setMax(null);
        }
    }

    public Question getQuestionById(Long id) throws DomainException {
        try {
            Question q2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Question q2 : Model.getQuestions()) {
                if (!q2.getId().equals(id)) continue;
                Model.getQuestions().remove(q2);
                break;
            }
            q2 = QuestionDAO.getById(id);
            Model.getQuestions().add(q2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return q2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Question cannot be retreived!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public void updateQuestion(Question q, String typeName, String qText, int qOrder, HashMap<String, HashMap<String, String>> rules) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType type = this.getTypeFromName(typeName);
            QuestionDAO.lock(q);
            q.setText(qText);
            int orderChange = 0;
            int oldOrder = q.getOrder();
            HashSet<Question> updateQ = new HashSet<Question>();
            HashSet<Question> auxqs = Model.getQuestions();
            if (oldOrder > qOrder) {
                orderChange = 1;
                for (Question qaux : auxqs) {
                    int auxOrder = qaux.getOrder();
                    if (auxOrder < qOrder || auxOrder >= oldOrder) continue;
                    updateQ.add(qaux);
                }
            } else if (oldOrder < qOrder) {
                --qOrder;
                orderChange = -1;
                for (Question qaux : auxqs) {
                    int auxOrder = qaux.getOrder();
                    if (auxOrder <= oldOrder || auxOrder > qOrder) continue;
                    updateQ.add(qaux);
                }
            }
            this.updateQuestionsOrder(updateQ, orderChange);
            q.setOrder(qOrder);
            DataType oldType = q.getQuestionType();
            if (!oldType.equals((Object)type)) {
                DataTypeDAO.lock(type);
                DataTypeDAO.lock(oldType);
                oldType.removeQuestion(q);
                type.addQuestion(q);
            }
            this.removeQuestionRules(q);
            QuestionDAO.update(q);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            this.newQuestionRules(q, rules);
            QuestionDAO.update(q);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Question cannot be updated!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public Property getPropertyById(Long id) throws DomainException {
        try {
            Property p2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Property p2 : Model.getProperties()) {
                if (!p2.getId().equals(id)) continue;
                Model.getProperties().remove(p2);
                break;
            }
            p2 = PropertyDAO.getById(id);
            Model.getProperties().add(p2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return p2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Property cannot be retreived!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public void updateProperty(Property p, String typeName, String reqName, String name, String description, HashMap<String, TuplePropertyRulesMap> rules) throws DomainException {
        try {
            Requirement oldReq;
            DataType oldType;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType type = this.getTypeFromName(typeName);
            Requirement req = null;
            if (reqName != null) {
                req = this.getRequirementFromName(reqName);
            }
            PropertyDAO.lock(p);
            p.setName(name);
            if (description != null) {
                p.setDescription(description);
            }
            if (!(oldType = p.getType()).equals((Object)type)) {
                DataTypeDAO.lock(type);
                DataTypeDAO.lock(oldType);
                oldType.removeProperty(p);
                type.addProperty(p);
            }
            if ((oldReq = p.getRequirement()) != null || req != null) {
                if (oldReq == null && req != null || !oldReq.equals((Object)req)) {
                    if (oldReq != null) {
                        Model.getRequirements().remove(oldReq);
                        oldReq = RequirementDAO.getById(oldReq.getId());
                        Model.getRequirements().add(oldReq);
                        oldReq.removeProperty(p);
                    } else {
                        this.notClassifiedRequirement.removeProperty(p);
                    }
                    p.setRequirement(req);
                    if (req != null) {
                        Model.getRequirements().remove(req);
                        req = RequirementDAO.getById(req.getId());
                        Model.getRequirements().add(req);
                        req.addProperty(p);
                    } else {
                        this.notClassifiedRequirement.getProperties().add(p);
                    }
                } else if (oldReq.equals((Object)req)) {
                    Model.getRequirements().remove(oldReq);
                    oldReq = RequirementDAO.getById(oldReq.getId());
                    Model.getRequirements().add(oldReq);
                    oldReq.removeProperty(p);
                    oldReq.addProperty(p);
                }
            } else {
                this.notClassifiedRequirement.getProperties().remove(p);
                this.notClassifiedRequirement.getProperties().add(p);
            }
            this.removePropertyRules(p);
            PropertyDAO.update(p);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            this.newPropertyRules(p, rules);
            PropertyDAO.update(p);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Property cannot be updated!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public Requirement getRequirementyById(Long id) throws DomainException {
        try {
            Requirement r2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Requirement r2 : Model.getRequirements()) {
                if (!r2.getId().equals(id)) continue;
                Model.getRequirements().remove(r2);
                break;
            }
            r2 = RequirementDAO.getById(id);
            Model.getRequirements().add(r2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return r2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Requirement cannot be retreived!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public void updateRequirement(Requirement r, String name, String description) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            RequirementDAO.lock(r);
            r.setName(name);
            if (description != null) {
                r.setDescription(description);
            }
            RequirementDAO.update(r);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Requirement cannot be updated!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public Decision getDecisionById(Long id) throws DomainException {
        try {
            Decision d2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Decision d2 : Model.getDecisions()) {
                if (!d2.getId().equals(id)) continue;
                Model.getDecisions().remove(d2);
                break;
            }
            d2 = DecisionDAO.getById(id);
            Model.getDecisions().add(d2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return d2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Decision cannot be retreived!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public void updateDecision(Decision d, String name, String desc, HashSet<Element> elements, HashMap<String, TupleDecisionRulesMap> rules) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DecisionDAO.lock(d);
            d.setName(name);
            if (desc != null) {
                d.setDescription(desc);
            }
            Set els = d.getElements();
            for (Element e : els) {
                ElementDAO.lock(e);
                e.removeDecision(d);
            }
            d.clearElements();
            for (Element e : elements) {
                ElementDAO.lock(e);
                d.addElement(e);
            }
            this.removeDecisionRules(d);
            DecisionDAO.update(d);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            this.newDecisionRules(d, rules);
            DecisionDAO.update(d);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Decision cannot be updated!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public Element getElementById(Long id) throws DomainException {
        try {
            Element e2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Element e2 : Model.getElements()) {
                if (!e2.getId().equals(id)) continue;
                Model.getElements().remove(e2);
                break;
            }
            e2 = ElementDAO.getById(id);
            Model.getElements().add(e2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return e2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Element cannot be retreived!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public void updateElement(Element e, String name) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ElementDAO.lock(e);
            e.setName(name);
            ElementDAO.update(e);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Element cannot be updated!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public IntegerType getIntegerTypeById(Long id) throws DomainException {
        try {
            IntegerType t2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (IntegerType t2 : Model.getIntegerTypes()) {
                if (!t2.getId().equals(id)) continue;
                Model.getIntegerTypes().remove(t2);
                break;
            }
            t2 = IntegerTypeDAO.getById(id);
            Model.getIntegerTypes().add(t2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return t2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public DataType getTypeById(Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType t = DataTypeDAO.getById(id);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return t;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", (Throwable)he);
        }
    }

    public void updateIntegerType(IntegerType type, String name, String desc, int min, boolean hasMin, int max, boolean hasMax) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            this.setIntegerTypeValues(type, name, desc, min, hasMin, max, hasMax);
            IntegerTypeDAO.update(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be updated!", (Throwable)he);
        }
    }

    private void newQuestionRules(Question q, HashMap<String, HashMap<String, String>> rules) {
        Set<String> ruleNames = rules.keySet();
        for (String rule : ruleNames) {
            QuestionRule qr = new QuestionRule();
            qr.setName(rule);
            q.addQuestionRule(qr);
            HashMap<String, String> restrictions = rules.get(rule);
            Set<String> restrictionTexts = restrictions.keySet();
            for (String qauxText : restrictionTexts) {
                Question qres = QuestionDAO.getByText(qauxText);
                if (qres == null) continue;
                new qrQuestionRestriction(qres, qr, restrictions.get(qauxText));
            }
        }
    }

    private void newPropertyRules(Property p, HashMap<String, TuplePropertyRulesMap> rules) {
        Set<String> ruleNames = rules.keySet();
        for (String rule : ruleNames) {
            TuplePropertyRulesMap restrictions = rules.get(rule);
            PropertyRule pr = new PropertyRule();
            pr.setName(rule);
            pr.setPropertyCondition(restrictions.condition);
            p.addPropertyRule(pr);
            Set<String> restictionTexts = restrictions.ifQuestions.keySet();
            for (String qText : restictionTexts) {
                Question qres = QuestionDAO.getByText(qText);
                if (qres == null) continue;
                new prQuestionRestriction(qres, pr, restrictions.ifQuestions.get(qText));
            }
        }
    }

    private void newDecisionRules(Decision d, HashMap<String, TupleDecisionRulesMap> rules) {
        Set<String> ruleNames = rules.keySet();
        for (String rule : ruleNames) {
            TupleDecisionRulesMap conditions = rules.get(rule);
            DecisionRule dr = new DecisionRule();
            dr.setName(rule);
            dr.setinfluence(conditions.influence);
            d.addDecisionRule(dr);
            Set<String> conditionTexts = conditions.ifProperties.keySet();
            for (String pName : conditionTexts) {
                Property pres = PropertyDAO.getByName(pName);
                if (pres == null) continue;
                new drPropertyCondition(pres, dr, conditions.ifProperties.get(pName));
            }
        }
    }

    private void removeQuestionRules(Question q) {
        Set qrules = q.getQuestionRules();
        for (QuestionRule qr : qrules) {
            qr.remove();
        }
        q.removeAllRules();
    }

    private void removePropertyRules(Property p) {
        Set prules = p.getPropertyRules();
        for (PropertyRule pr : prules) {
            pr.remove();
        }
        p.removeAllRules();
    }

    private void removeDecisionRules(Decision d) {
        Set drules = d.getDecisionRules();
        for (DecisionRule dr : drules) {
            dr.remove();
        }
        d.removeAllRules();
    }

    public HashMap<String, HashMap<String, String>> getQuestionRulesInfo(Question q) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            QuestionDAO.lock(q);
            HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>();
            for (QuestionRule qr : q.getQuestionRules()) {
                HashMap<String, String> res = new HashMap<String, String>();
                result.put(qr.getName(), res);
                for (qrQuestionRestriction qrq : qr.getQuestionRestrictions()) {
                    res.put(qrq.getQuestion().getText(), qrq.getRestriction());
                }
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return result;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nRules Info cannot be retrieved!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public HashMap<String, TuplePropertyRulesMap> getPropertyRulesInfo(Property p) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            PropertyDAO.lock(p);
            HashMap<String, TuplePropertyRulesMap> result = new HashMap<String, TuplePropertyRulesMap>();
            for (PropertyRule pr : p.getPropertyRules()) {
                TuplePropertyRulesMap res = new TuplePropertyRulesMap();
                result.put(pr.getName(), res);
                res.condition = pr.getPropertyCondition();
                for (prQuestionRestriction prq : pr.getQuestionRestrictions()) {
                    res.ifQuestions.put(prq.getQuestion().getText(), prq.getRestriction());
                }
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return result;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public HashMap<String, TupleDecisionRulesMap> getDecisionRulesInfo(Decision d) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DecisionDAO.lock(d);
            HashMap<String, TupleDecisionRulesMap> result = new HashMap<String, TupleDecisionRulesMap>();
            for (DecisionRule dr : d.getDecisionRules()) {
                TupleDecisionRulesMap res = new TupleDecisionRulesMap();
                result.put(dr.getName(), res);
                res.influence = dr.getInfluence();
                for (drPropertyCondition drp : dr.getPropertyConditions()) {
                    res.ifProperties.put(drp.getProperty().getName(), drp.getPropertyCondition());
                }
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return result;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public Question getQuestionFromText(String text) throws DomainException {
        for (Question q : Model.getQuestions()) {
            if (!q.getText().equals(text)) continue;
            return q;
        }
        return null;
    }

    public Requirement getRequirementFromName(String name) throws DomainException {
        for (Requirement r : Model.getRequirements()) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public DataType getTypeFromName(String name) throws DomainException {
        for (DataType d : Model.getTypes()) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    public boolean questionAlredyExists(String text, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Question q = QuestionDAO.getByText(text);
            boolean b = q == null ? false : (isNew ? true : !q.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", (Throwable)e);
        }
    }

    public boolean propertyAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Property p = PropertyDAO.getByName(name);
            boolean b = p == null ? false : (isNew ? true : !p.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", (Throwable)e);
        }
    }

    public boolean requirementAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Requirement r = RequirementDAO.getByName(name);
            boolean b = r == null ? false : (isNew ? true : !r.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", (Throwable)e);
        }
    }

    public boolean decisionAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Decision d = DecisionDAO.getByName(name);
            boolean b = d == null ? false : (isNew ? true : !d.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", (Throwable)e);
        }
    }

    public boolean elementAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Element e = ElementDAO.getByName(name);
            boolean b = e == null ? false : (isNew ? true : !e.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", (Throwable)e);
        }
    }

    public boolean typeAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType d = DataTypeDAO.getByName(name);
            boolean b = d == null ? false : (isNew ? true : !d.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", (Throwable)e);
        }
    }

    private void updateQuestionsOrder(HashSet<Question> updateQ, int orderChange) throws DomainException {
        for (Question qaux : updateQ) {
            int auxOrder = qaux.getOrder();
            Model.getQuestions().remove(qaux);
            qaux = QuestionDAO.getById(qaux.getId());
            Model.getQuestions().add(qaux);
            qaux.setOrder(auxOrder + orderChange);
            QuestionDAO.update(qaux);
        }
    }

    public void swapQuestionsOrder(Question qUp, Question qDown) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Model.getQuestions().remove(qUp);
            qUp = QuestionDAO.getById(qUp.getId());
            Model.getQuestions().add(qUp);
            Model.getQuestions().remove(qDown);
            qDown = QuestionDAO.getById(qDown.getId());
            Model.getQuestions().add(qDown);
            QuestionDAO.lock(qUp);
            QuestionDAO.lock(qDown);
            if (qUp.appearInRules(qDown)) {
                throw new DomainException("The upper question appears in some of the rules of the down one.\nCheck it and try again.");
            }
            int orderUp = qUp.getOrder();
            int orderDown = qDown.getOrder();
            qUp.setOrder(orderDown);
            qDown.setOrder(orderUp);
            QuestionDAO.update(qUp);
            QuestionDAO.update(qDown);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Questions cannot swap their order!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }

    public Requirement getNotClassifiedRequirement() throws DomainException {
        try {
            if (this.notClassifiedRequirement == null) {
                this.notClassifiedRequirement = new Requirement("Not Classified");
                this.notClassifiedRequirement.setId(new Long(-1L));
                HibernateController.openSession();
                HibernateController.beginTransaction();
                HashSet<Property> props = Model.getProperties();
                for (Property p : props) {
                    if (p.getRequirement() != null) continue;
                    this.notClassifiedRequirement.getProperties().add(p);
                }
                HibernateController.commitTransaction();
                HibernateController.closeSession();
            }
            return this.notClassifiedRequirement;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe \"Not Classified\" Requirement cannot be initialized!", (Throwable)he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", (Throwable)ce);
        }
    }
}

