/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.dataType;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public abstract class GenericTypeDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private boolean isNew;
    private String name;
    private String desc;
    private Shell shell;

    public GenericTypeDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public GenericTypeDialog(Shell parentShell, String name, String desc) {
        super(parentShell);
        this.isNew = false;
        this.name = name;
        this.desc = desc;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(400, 400);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New ");
        } else {
            this.shell.setText("Edit ");
        }
        this.createContentsSpecific(this.shell);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        TabFolder tabs = new TabFolder(contents, 128);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        tabs.setLayout((Layout)new GridLayout());
        this.createInformationTab(tabs);
        this.createAttributesTab(tabs);
        if (!this.isNew) {
            this.fillValues();
        }
        return contents;
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 1, true, false);
        this.nameText.setLayoutData((Object)gd1);
        Label label2 = new Label(content, 0);
        label2.setText("Description: ");
        this.descriptionText = new Text(content, 2050);
        GridData gd2 = new GridData(4, 4, true, true);
        this.descriptionText.setLayoutData((Object)gd2);
    }

    private void fillValues() {
        this.nameText.setText(this.name);
        if (this.desc != null) {
            this.descriptionText.setText(this.desc);
        }
        this.fillValuesSpecific();
    }

    protected void okPressed() {
        try {
            String tName = this.nameText.getText();
            String tDescription = this.descriptionText.getText();
            Long id = null;
            if (!this.isNew) {
                id = this.getTypeId();
            }
            if (tName == null || tName.equals("")) {
                this.showError("Error", "The name can't be empty");
            } else if (DomainController.getInstance().typeAlredyExists(tName, this.isNew, id)) {
                this.showError("Error", "A Type with the same name alredy exists");
            } else {
                this.doOk(tName, tDescription, this.isNew);
                super.okPressed();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showError("Error", "Numbers not in the correct format");
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknow Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }

    public abstract void createContentsSpecific(Shell var1);

    public abstract void createAttributesTab(TabFolder var1);

    public abstract void fillValuesSpecific();

    public abstract void doOk(String var1, String var2, boolean var3) throws DomainException;

    public abstract Long getTypeId();
}

