/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.dataType;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.Activator;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.gui.dialogs.dataType.GenericTypeDialog;
import upc.gessi.architech.hibernatehelper.domainModel.type.IntegerType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;

public class IntegerTypeDialog
extends GenericTypeDialog {
    Text minText;
    Text maxText;
    IntegerType type;

    public IntegerTypeDialog(Shell parentShell) {
        super(parentShell);
    }

    public IntegerTypeDialog(Shell parentShell, IntegerType type) throws DomainException {
        super(parentShell, type.getName(), type.getDescription());
        this.type = type = DomainController.getInstance().getIntegerTypeById(type.getId());
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Integer Type");
        this.setTitle("Integer Type");
        this.setMessage("Enter the data fot this Integer Type");
        this.setTitleImage(Activator.getImageDescriptor("integerIcon_48x52.png").createImage());
    }

    @Override
    public void createAttributesTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Min: ");
        this.minText = new Text(content, 2048);
        Label label2 = new Label(content, 0);
        label2.setText("Max: ");
        this.maxText = new Text(content, 2048);
    }

    @Override
    public void fillValuesSpecific() {
        Integer min = this.type.getMin();
        Integer max = this.type.getMax();
        if (min != null) {
            this.minText.setText(String.valueOf(min));
        }
        if (max != null) {
            this.maxText.setText(String.valueOf(max));
        }
    }

    @Override
    public void doOk(String name, String desc, boolean isNew) throws DomainException {
        String tMin = this.minText.getText();
        String tMax = this.maxText.getText();
        boolean hasMin = !tMin.equals("");
        boolean hasMax = !tMax.equals("");
        int parsedMin = 0;
        int parsedMax = 0;
        if (hasMin) {
            parsedMin = Integer.parseInt(tMin);
        }
        if (hasMax) {
            parsedMax = Integer.parseInt(tMax);
        }
        if (hasMin && hasMax && parsedMin > parsedMax) {
            throw new DomainException("Min has to be lesser or equal than Max");
        }
        if (isNew) {
            DomainController.getInstance().newIntegerType(name, desc, parsedMin, hasMin, parsedMax, hasMax);
        } else {
            DomainController.getInstance().updateIntegerType(this.type, name, desc, parsedMin, hasMin, parsedMax, hasMax);
        }
    }

    @Override
    public Long getTypeId() {
        return this.type.getId();
    }
}

