/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.decision;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.properties.PropertiesLabelProvider;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domainModel.property.Property;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;
import upc.gessi.architech.utils.TupleDecisionRulesMap;

public class DecisionDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private List elementsList;
    private Text conditionText;
    private Combo influenceCombo;
    private List rulesList;
    private List propertiesList;
    private boolean isNew;
    private Decision decision;
    private HashSet<Element> elements;
    private HashMap<String, TupleDecisionRulesMap> rulesMap;
    private Shell shell;

    public DecisionDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.rulesMap = new HashMap();
        this.elements = new HashSet();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DecisionDialog(Shell parentShell, Decision d) throws DomainException {
        super(parentShell);
        this.decision = d = DomainController.getInstance().getDecisionById(d.getId());
        this.isNew = false;
        this.elements = new HashSet();
        this.rulesMap = DomainController.getInstance().getDecisionRulesInfo(d);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(500, 650);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Decision");
        } else {
            this.shell.setText("Edit Decision");
        }
        this.setTitle("Decision");
        this.setMessage("Enter the data for this decision");
        this.setTitleImage(Activator.getImageDescriptor("decisionsIcon_48x48.png").createImage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        TabFolder tabs = new TabFolder(contents, 128);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        tabs.setLayout((Layout)new GridLayout());
        this.createInformationTab(tabs);
        this.createRulesTab(tabs);
        if (!this.isNew) {
            this.fillValues();
        }
        return contents;
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 16384, true, false);
        this.nameText.setLayoutData((Object)gd1);
        Label label2 = new Label(content, 0);
        label2.setText("Description: ");
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 2;
        label2.setLayoutData((Object)gd2);
        this.descriptionText = new Text(content, 2050);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)gd3);
        Label label3 = new Label(content, 0);
        label3.setText("Elements: ");
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        label3.setLayoutData((Object)gd4);
        this.elementsList = new List(content, 2048);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.verticalSpan = 2;
        this.elementsList.setLayoutData((Object)gd5);
        Button butt = new Button(content, 8);
        butt.setText("Add...");
        butt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(DecisionDialog.this.shell, (ILabelProvider)new ElementLabelProvider());
                    HashSet<Element> allElements = DomainController.getInstance().getAllElements();
                    HashSet<Element> validElements = new HashSet<Element>();
                    String[] items = DecisionDialog.this.elementsList.getItems();
                    for (Object e : allElements) {
                        boolean add = true;
                        int i = 0;
                        while (i < items.length) {
                            if (e.getName().equals(items[i])) {
                                add = false;
                            }
                            ++i;
                        }
                        if (!add) continue;
                        validElements.add((Element)e);
                    }
                    dg.setElements(validElements.toArray());
                    dg.setTitle("Browse Element");
                    dg.setMessage("Select one or more elements to add to the decision");
                    if (dg.open() == 0) {
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e;
                            e = objectArray[n2];
                            DecisionDialog.this.elementsList.add(e.getName());
                            DecisionDialog.this.elements.add(e);
                            ++n2;
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DecisionDialog.this.shell);
                    dd.open();
                }
            }
        });
        Button butt2 = new Button(content, 8);
        butt2.setText("Delete...");
        butt2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (DecisionDialog.this.elementsList.getSelection().length != 0) {
                    String[] stringArray = DecisionDialog.this.elementsList.getSelection();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String eName = stringArray[n2];
                        DecisionDialog.this.elementsList.remove(eName);
                        for (Element e : DecisionDialog.this.elements) {
                            if (!e.getName().equals(eName)) continue;
                            DecisionDialog.this.elements.remove(e);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void createRulesTab(TabFolder tabs) {
        TabItem tabitem = new TabItem(tabs, 0);
        tabitem.setText("Rules");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabitem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Rules:");
        Label label2 = new Label(content, 0);
        label2.setText("IF:");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        label2.setLayoutData((Object)gd1);
        this.rulesList = new List(content, 2052);
        GridData gd2 = new GridData(0x1000000, 4, false, true);
        gd2.verticalSpan = 6;
        gd2.heightHint = 125;
        gd2.widthHint = 70;
        this.rulesList.setLayoutData((Object)gd2);
        this.rulesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (DecisionDialog.this.rulesList.getSelection().length != 0) {
                    DecisionDialog.this.propertiesList.removeAll();
                    DecisionDialog.this.conditionText.setText("");
                    TupleDecisionRulesMap res = (TupleDecisionRulesMap)DecisionDialog.this.rulesMap.get(DecisionDialog.this.rulesList.getSelection()[0]);
                    if (res.influence != -1) {
                        DecisionDialog.this.influenceCombo.select(res.influence);
                    } else {
                        DecisionDialog.this.influenceCombo.deselectAll();
                    }
                    for (String p : res.ifProperties.keySet()) {
                        DecisionDialog.this.propertiesList.add(p);
                    }
                    DecisionDialog.this.influenceCombo.setEnabled(true);
                }
            }
        });
        this.propertiesList = new List(content, 2820);
        GridData gd3 = new GridData(0x1000000, 0x1000000, false, false);
        gd3.verticalSpan = 2;
        gd3.heightHint = 120;
        gd3.widthHint = 200;
        this.propertiesList.setLayoutData((Object)gd3);
        this.propertiesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                TupleDecisionRulesMap res = (TupleDecisionRulesMap)DecisionDialog.this.rulesMap.get(DecisionDialog.this.rulesList.getSelection()[0]);
                DecisionDialog.this.conditionText.setText(res.ifProperties.get(DecisionDialog.this.propertiesList.getSelection()[0]));
            }
        });
        Button addQuestionButton = new Button(content, 8);
        addQuestionButton.setText("Add");
        addQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (DecisionDialog.this.rulesList.getSelection().length != 0) {
                        ElementListSelectionDialog dg = new ElementListSelectionDialog(DecisionDialog.this.shell, (ILabelProvider)new PropertiesLabelProvider());
                        HashSet<Property> allProperties = DomainController.getInstance().getAllProperties();
                        HashSet<Property> validProperties = new HashSet<Property>();
                        String[] items = DecisionDialog.this.propertiesList.getItems();
                        for (Property p : allProperties) {
                            boolean add = true;
                            int i = 0;
                            while (i < items.length) {
                                if (p.getName().equals(items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                            if (!add) continue;
                            validProperties.add(p);
                        }
                        dg.setElements(validProperties.toArray());
                        dg.setTitle("Browse Property");
                        dg.setMessage("Select a Property:");
                        dg.setMultipleSelection(false);
                        if (dg.open() == 0) {
                            Property result = (Property)dg.getFirstResult();
                            String pName = result.getName();
                            DecisionDialog.this.propertiesList.add(pName);
                            TupleDecisionRulesMap res = (TupleDecisionRulesMap)DecisionDialog.this.rulesMap.get(DecisionDialog.this.rulesList.getSelection()[0]);
                            res.ifProperties.put(pName, "");
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DecisionDialog.this.shell);
                    dd.open();
                }
            }
        });
        Button delQuestionButton = new Button(content, 8);
        delQuestionButton.setText("Delete");
        delQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (DecisionDialog.this.rulesList.getSelection().length != 0) {
                    TupleDecisionRulesMap res = (TupleDecisionRulesMap)DecisionDialog.this.rulesMap.get(DecisionDialog.this.rulesList.getSelection()[0]);
                    String selProperty = DecisionDialog.this.propertiesList.getSelection()[0];
                    DecisionDialog.this.propertiesList.remove(selProperty);
                    res.ifProperties.remove(selProperty);
                    DecisionDialog.this.conditionText.setText("");
                }
            }
        });
        Label label3 = new Label(content, 0);
        label3.setText("Restriction on the condition: ");
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        label3.setLayoutData((Object)gd4);
        this.conditionText = new Text(content, 2818);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.horizontalSpan = 2;
        this.conditionText.setLayoutData((Object)gd5);
        this.conditionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (DecisionDialog.this.propertiesList.getSelection().length == 0) {
                    DecisionDialog.this.propertiesList.setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                TupleDecisionRulesMap selRes = (TupleDecisionRulesMap)DecisionDialog.this.rulesMap.get(DecisionDialog.this.rulesList.getSelection()[0]);
                selRes.ifProperties.put(DecisionDialog.this.propertiesList.getSelection()[0], DecisionDialog.this.conditionText.getText());
            }
        });
        Label label4 = new Label(content, 0);
        label4.setText("Decision influence: ");
        GridData gd8 = new GridData(4, 0x1000000, true, false);
        gd8.horizontalSpan = 2;
        label4.setLayoutData((Object)gd8);
        this.influenceCombo = new Combo(content, 12);
        GridData gd9 = new GridData(4, 0x1000000, true, false);
        gd9.horizontalSpan = 2;
        this.influenceCombo.setLayoutData((Object)gd9);
        this.fillInfluenceComboValues();
        this.influenceCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String selRule = DecisionDialog.this.rulesList.getSelection()[0];
                TupleDecisionRulesMap selRes = (TupleDecisionRulesMap)DecisionDialog.this.rulesMap.get(selRule);
                selRes.influence = DecisionDialog.this.influenceCombo.getSelectionIndex();
            }
        });
        this.influenceCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (DecisionDialog.this.rulesList.getSelection().length == 0) {
                    DecisionDialog.this.influenceCombo.setEnabled(false);
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Button addRule = new Button(content, 8);
        addRule.setText("New Rule");
        GridData gd6 = new GridData(1, 0x1000000, false, false);
        gd6.horizontalSpan = 3;
        addRule.setLayoutData((Object)gd6);
        addRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                InputDialog dg = new InputDialog(DecisionDialog.this.shell, "New Rule", "Introduce a name for the rule: ", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.equals("")) {
                            return "Introdue a Name";
                        }
                        if (DecisionDialog.this.ruleExists(newText)) {
                            return "A rule with the same name alredy exists";
                        }
                        return null;
                    }
                });
                if (dg.open() == 0) {
                    String rName = dg.getValue();
                    DecisionDialog.this.rulesList.add(rName);
                    DecisionDialog.this.rulesMap.put(rName, new TupleDecisionRulesMap());
                }
            }
        });
        Button delRule = new Button(content, 8);
        delRule.setText("Delete Rule");
        GridData gd7 = new GridData(1, 0x1000000, false, false);
        gd7.horizontalSpan = 3;
        delRule.setLayoutData((Object)gd7);
        delRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String rName = DecisionDialog.this.rulesList.getSelection()[0];
                DecisionDialog.this.rulesList.remove(rName);
                DecisionDialog.this.propertiesList.removeAll();
                DecisionDialog.this.conditionText.setText("");
                DecisionDialog.this.rulesMap.remove(rName);
                DecisionDialog.this.influenceCombo.setEnabled(false);
            }
        });
    }

    private void fillValues() {
        this.nameText.setText(this.decision.getName());
        String pDescription = this.decision.getDescription();
        if (pDescription != null) {
            this.descriptionText.setText(pDescription);
        }
        for (Element e : this.decision.getElements()) {
            this.elementsList.add(e.getName());
            this.elements.add(e);
        }
        for (String qr : this.rulesMap.keySet()) {
            this.rulesList.add(qr);
        }
    }

    private void fillInfluenceComboValues() {
        this.influenceCombo.add("Denies", 0);
        this.influenceCombo.add("Weakly harms", 1);
        this.influenceCombo.add("Weakly helps", 2);
        this.influenceCombo.add("Makes", 3);
    }

    private boolean validRules() {
        for (String rule : this.rulesMap.keySet()) {
            TupleDecisionRulesMap res = this.rulesMap.get(rule);
            if (res.ifProperties.isEmpty()) {
                return false;
            }
            if (res.influence == -1) {
                return false;
            }
            for (String q : res.ifProperties.keySet()) {
                if (!res.ifProperties.get(q).equals("")) continue;
                return false;
            }
        }
        return true;
    }

    protected void okPressed() {
        try {
            String dName = this.nameText.getText();
            String dDescription = this.descriptionText.getText();
            Long id = null;
            if (!this.isNew) {
                id = this.decision.getId();
            }
            if (dName == null || dName.equals("")) {
                this.showError("Error", "The name can't be empty");
            } else if (!this.validRules()) {
                this.showError("Error", "There is some problem with the rules.\n Check them");
            } else if (DomainController.getInstance().decisionAlredyExists(dName, this.isNew, id)) {
                this.showError("Error", "A decision with the same name alredy exists");
            } else {
                if (this.isNew) {
                    DomainController.getInstance().newDecision(dName, dDescription, this.elements, this.rulesMap);
                } else {
                    DomainController.getInstance().updateDecision(this.decision, dName, dDescription, this.elements, this.rulesMap);
                }
                super.okPressed();
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    private boolean ruleExists(String name) {
        Set<String> ns = this.rulesMap.keySet();
        for (String n : ns) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

