/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.property;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.questions.QuestionLabelProvider;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.domain.controller.Model;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domainModel.property.Property;
import upc.gessi.architech.hibernatehelper.domainModel.property.Requirement;
import upc.gessi.architech.hibernatehelper.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;
import upc.gessi.architech.utils.TuplePropertyRulesMap;

public class PropertyDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private Text restrictionText;
    private Text conditionText;
    private List rulesList;
    private List questionsList;
    private List typesList;
    private List requirementsList;
    private boolean isNew;
    private Property property;
    private DataType type;
    private Requirement requirement;
    private HashMap<String, TuplePropertyRulesMap> rulesMap;
    private Shell shell;

    public PropertyDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.rulesMap = new HashMap();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public PropertyDialog(Shell parentShell, Property p) throws DomainException {
        super(parentShell);
        this.isNew = false;
        this.property = p = DomainController.getInstance().getPropertyById(p.getId());
        this.type = DomainController.getInstance().getTypeById(p.getType().getId());
        this.requirement = p.getRequirement() != null ? DomainController.getInstance().getRequirementyById(p.getRequirement().getId()) : null;
        this.rulesMap = DomainController.getInstance().getPropertyRulesInfo(p);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(500, 650);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Property");
        } else {
            this.shell.setText("Edit Property");
        }
        this.setTitle("Property");
        this.setMessage("Enter the data for this property");
        this.setTitleImage(Activator.getImageDescriptor("propertiesIcon_48x48.png").createImage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        TabFolder tabs = new TabFolder(contents, 128);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        tabs.setLayout((Layout)new GridLayout());
        this.createInformationTab(tabs);
        this.createRulesTab(tabs);
        if (!this.isNew) {
            this.fillValues();
        }
        return contents;
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd1);
        Label label4 = new Label(content, 0);
        label4.setText("Description: ");
        GridData gd6 = new GridData(4, 0x1000000, true, false);
        gd6.horizontalSpan = 3;
        label4.setLayoutData((Object)gd6);
        this.descriptionText = new Text(content, 2050);
        GridData gd7 = new GridData(4, 4, true, true);
        gd7.horizontalSpan = 3;
        this.descriptionText.setLayoutData((Object)gd7);
        Label label2 = new Label(content, 0);
        label2.setText("Type: ");
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 1;
        label2.setLayoutData((Object)gd2);
        Label label3 = new Label(content, 0);
        label3.setText("Requirement: ");
        GridData gd3 = new GridData(4, 0x1000000, true, false);
        gd3.horizontalSpan = 2;
        label3.setLayoutData((Object)gd3);
        this.typesList = new List(content, 2052);
        GridData gd4 = new GridData(0x1000000, 4, false, true);
        gd4.heightHint = 50;
        gd4.widthHint = 150;
        this.typesList.setLayoutData((Object)gd4);
        try {
            HashSet<DataType> types = Model.getTypes();
            for (DataType t : types) {
                this.typesList.add(t.getName());
            }
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
        this.requirementsList = new List(content, 2052);
        GridData gd5 = new GridData(0x1000000, 4, false, true);
        gd5.heightHint = 50;
        gd5.widthHint = 150;
        this.requirementsList.setLayoutData((Object)gd5);
        try {
            HashSet<Requirement> reqs = Model.getRequirements();
            Requirement notC = DomainController.getInstance().getNotClassifiedRequirement();
            for (Requirement r : reqs) {
                if (r.equals((Object)notC)) continue;
                this.requirementsList.add(r.getName());
            }
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
        Button butt2 = new Button(content, 8);
        butt2.setText("Unselect Requirement");
        butt2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                PropertyDialog.this.requirementsList.deselectAll();
            }
        });
    }

    private void createRulesTab(TabFolder tabs) {
        TabItem tabitem = new TabItem(tabs, 0);
        tabitem.setText("Rules");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabitem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Rules:");
        Label label2 = new Label(content, 0);
        label2.setText("IF:");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        label2.setLayoutData((Object)gd1);
        this.rulesList = new List(content, 2052);
        GridData gd2 = new GridData(0x1000000, 4, false, true);
        gd2.verticalSpan = 6;
        gd2.heightHint = 125;
        gd2.widthHint = 70;
        this.rulesList.setLayoutData((Object)gd2);
        this.rulesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (PropertyDialog.this.rulesList.getSelection().length != 0) {
                    PropertyDialog.this.questionsList.removeAll();
                    PropertyDialog.this.restrictionText.setText("");
                    TuplePropertyRulesMap res = (TuplePropertyRulesMap)PropertyDialog.this.rulesMap.get(PropertyDialog.this.rulesList.getSelection()[0]);
                    PropertyDialog.this.conditionText.setText(res.condition);
                    for (String q : res.ifQuestions.keySet()) {
                        PropertyDialog.this.questionsList.add(q);
                    }
                }
            }
        });
        this.questionsList = new List(content, 2820);
        GridData gd3 = new GridData(0x1000000, 0x1000000, false, false);
        gd3.verticalSpan = 2;
        gd3.heightHint = 120;
        gd3.widthHint = 200;
        this.questionsList.setLayoutData((Object)gd3);
        this.questionsList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                TuplePropertyRulesMap res = (TuplePropertyRulesMap)PropertyDialog.this.rulesMap.get(PropertyDialog.this.rulesList.getSelection()[0]);
                PropertyDialog.this.restrictionText.setText(res.ifQuestions.get(PropertyDialog.this.questionsList.getSelection()[0]));
            }
        });
        Button addQuestionButton = new Button(content, 8);
        addQuestionButton.setText("Add");
        addQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (PropertyDialog.this.rulesList.getSelection().length != 0) {
                        ElementListSelectionDialog dg = new ElementListSelectionDialog(PropertyDialog.this.shell, (ILabelProvider)new QuestionLabelProvider());
                        HashSet<Question> allQuestions = Model.getQuestions();
                        HashSet<Question> validQuestions = new HashSet<Question>();
                        String[] items = PropertyDialog.this.questionsList.getItems();
                        for (Question q : allQuestions) {
                            boolean add = true;
                            int i = 0;
                            while (i < items.length) {
                                if (q.getText().equals(items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                            if (!add) continue;
                            validQuestions.add(q);
                        }
                        dg.setElements(validQuestions.toArray());
                        dg.setTitle("Browse Question");
                        dg.setMessage("Select a Question:");
                        dg.setMultipleSelection(false);
                        if (dg.open() == 0) {
                            Question result = (Question)dg.getFirstResult();
                            String qText = result.getText();
                            PropertyDialog.this.questionsList.add(qText);
                            TuplePropertyRulesMap res = (TuplePropertyRulesMap)PropertyDialog.this.rulesMap.get(PropertyDialog.this.rulesList.getSelection()[0]);
                            res.ifQuestions.put(qText, "");
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, PropertyDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, PropertyDialog.this.shell);
                    dd.open();
                }
            }
        });
        Button delQuestionButton = new Button(content, 8);
        delQuestionButton.setText("Delete");
        delQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (PropertyDialog.this.rulesList.getSelection().length != 0) {
                    TuplePropertyRulesMap res = (TuplePropertyRulesMap)PropertyDialog.this.rulesMap.get(PropertyDialog.this.rulesList.getSelection()[0]);
                    String selQuestion = PropertyDialog.this.questionsList.getSelection()[0];
                    PropertyDialog.this.questionsList.remove(selQuestion);
                    res.ifQuestions.remove(selQuestion);
                    PropertyDialog.this.restrictionText.setText("");
                }
            }
        });
        Label label3 = new Label(content, 0);
        label3.setText("Restriction on the answer: ");
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        label3.setLayoutData((Object)gd4);
        this.restrictionText = new Text(content, 2818);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.horizontalSpan = 2;
        this.restrictionText.setLayoutData((Object)gd5);
        this.restrictionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (PropertyDialog.this.questionsList.getSelection().length == 0) {
                    PropertyDialog.this.questionsList.setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                TuplePropertyRulesMap selRes = (TuplePropertyRulesMap)PropertyDialog.this.rulesMap.get(PropertyDialog.this.rulesList.getSelection()[0]);
                selRes.ifQuestions.put(PropertyDialog.this.questionsList.getSelection()[0], PropertyDialog.this.restrictionText.getText());
            }
        });
        Label label4 = new Label(content, 0);
        label4.setText("Property Condition: ");
        GridData gd8 = new GridData(4, 0x1000000, true, false);
        gd8.horizontalSpan = 2;
        label4.setLayoutData((Object)gd8);
        this.conditionText = new Text(content, 2818);
        GridData gd9 = new GridData(4, 4, true, true);
        gd9.horizontalSpan = 2;
        this.conditionText.setLayoutData((Object)gd5);
        this.conditionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (PropertyDialog.this.rulesList.getSelection().length == 0) {
                    PropertyDialog.this.rulesList.setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                String selRule = PropertyDialog.this.rulesList.getSelection()[0];
                TuplePropertyRulesMap selRes = (TuplePropertyRulesMap)PropertyDialog.this.rulesMap.get(selRule);
                selRes.condition = PropertyDialog.this.conditionText.getText();
            }
        });
        Button addRule = new Button(content, 8);
        addRule.setText("New Rule");
        GridData gd6 = new GridData(1, 0x1000000, false, false);
        gd6.horizontalSpan = 3;
        addRule.setLayoutData((Object)gd6);
        addRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                InputDialog dg = new InputDialog(PropertyDialog.this.shell, "New Rule", "Introduce a name for the rule: ", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.equals("")) {
                            return "Introdue a Name";
                        }
                        return null;
                    }
                });
                if (dg.open() == 0) {
                    String rName = dg.getValue();
                    PropertyDialog.this.rulesList.add(rName);
                    PropertyDialog.this.rulesMap.put(rName, new TuplePropertyRulesMap());
                }
            }
        });
        Button delRule = new Button(content, 8);
        delRule.setText("Delete Rule");
        GridData gd7 = new GridData(1, 0x1000000, false, false);
        gd7.horizontalSpan = 3;
        delRule.setLayoutData((Object)gd7);
        delRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String rName = PropertyDialog.this.rulesList.getSelection()[0];
                PropertyDialog.this.rulesList.remove(rName);
                PropertyDialog.this.questionsList.removeAll();
                PropertyDialog.this.restrictionText.setText("");
                PropertyDialog.this.conditionText.setText("");
                PropertyDialog.this.rulesMap.remove(rName);
            }
        });
    }

    private void fillValues() {
        this.nameText.setText(this.property.getName());
        String pDescription = this.property.getDescription();
        if (pDescription != null) {
            this.descriptionText.setText(pDescription);
        }
        String[] selType = new String[]{this.type.getName()};
        this.typesList.setSelection(selType);
        if (this.requirement != null) {
            String[] selReq = new String[]{this.requirement.getName()};
            this.requirementsList.setSelection(selReq);
        }
        for (String qr : this.rulesMap.keySet()) {
            this.rulesList.add(qr);
        }
    }

    private boolean validRules() {
        for (String rule : this.rulesMap.keySet()) {
            TuplePropertyRulesMap res = this.rulesMap.get(rule);
            if (res.ifQuestions.isEmpty()) {
                return false;
            }
            if (res.condition.equals("")) {
                return false;
            }
            for (String q : res.ifQuestions.keySet()) {
                if (!res.ifQuestions.get(q).equals("")) continue;
                return false;
            }
        }
        return true;
    }

    protected void okPressed() {
        try {
            String pName = this.nameText.getText();
            String pDescription = this.descriptionText.getText();
            String typeName = null;
            if (this.typesList.getSelection().length != 0) {
                typeName = this.typesList.getSelection()[0];
            }
            String rName = null;
            Long id = null;
            if (!this.isNew) {
                id = this.property.getId();
            }
            if (this.requirementsList.getSelection().length != 0) {
                rName = this.requirementsList.getSelection()[0];
            }
            if (pName == null || pName.equals("")) {
                this.showError("Error", "The name can't be empty");
            } else if (typeName == null) {
                this.showError("Error", "You have to select a type");
            } else if (!this.validRules()) {
                this.showError("Error", "There is some problem with the rules.\nCheck them");
            } else if (DomainController.getInstance().propertyAlredyExists(pName, this.isNew, id)) {
                this.showError("Error", "A property with the same name alredy exists");
            } else {
                if (this.isNew) {
                    DomainController.getInstance().newProperty(typeName, rName, pName, pDescription, this.rulesMap);
                } else {
                    DomainController.getInstance().updateProperty(this.property, typeName, rName, pName, pDescription, this.rulesMap);
                }
                super.okPressed();
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

