/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.property;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.Activator;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domainModel.property.Requirement;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class RequirementDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private boolean isNew;
    private Requirement requirement;
    private Shell shell;

    public RequirementDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public RequirementDialog(Shell parentShell, Requirement r) throws DomainException {
        super(parentShell);
        this.requirement = r = DomainController.getInstance().getRequirementyById(r.getId());
        this.isNew = false;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(400, 320);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Requirement");
        } else {
            this.shell.setText("Edit Requirement");
        }
        this.setTitle("Requirement");
        this.setMessage("Enter the data for this requirement");
        this.setTitleImage(Activator.getImageDescriptor("requirementIcon_48x48.png").createImage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createWidgets(contents);
        if (!this.isNew) {
            this.fillValues();
        }
        return contents;
    }

    private void createWidgets(Composite content) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 1, true, false);
        this.nameText.setLayoutData((Object)gd1);
        Label label2 = new Label(content, 0);
        label2.setText("Description: ");
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 2;
        label2.setLayoutData((Object)gd2);
        this.descriptionText = new Text(content, 2818);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)gd3);
    }

    private void fillValues() {
        this.nameText.setText(this.requirement.getName());
        String rDescription = this.requirement.getDescription();
        if (rDescription != null) {
            this.descriptionText.setText(rDescription);
        }
    }

    protected void okPressed() {
        try {
            String rName = this.nameText.getText();
            String rDescription = this.descriptionText.getText();
            Long id = null;
            if (!this.isNew) {
                id = this.requirement.getId();
            }
            if (rName == null || rName.equals("")) {
                this.showError("Error", "The name can't be empty");
            } else if (DomainController.getInstance().requirementAlredyExists(rName, this.isNew, id)) {
                this.showError("Error", "A requirement with the same name alredy exists");
            } else {
                if (this.isNew) {
                    DomainController.getInstance().newRequirement(rName, rDescription);
                } else {
                    DomainController.getInstance().updateRequirement(this.requirement, rName, rDescription);
                }
                super.okPressed();
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

