/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.question;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.questions.QuestionLabelProvider;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.domain.controller.Model;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class QuestionDialog
extends TitleAreaDialog {
    private Combo orderCombo;
    private Text questionText;
    private Text restrictionText;
    private List rulesList;
    private List questionsList;
    private List typesList;
    private boolean isNew;
    private Question question;
    private DataType type;
    private HashMap<String, HashMap<String, String>> rulesMap;
    private Shell shell;

    public QuestionDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.rulesMap = new HashMap();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public QuestionDialog(Shell parentShell, Question q) throws DomainException {
        super(parentShell);
        this.question = q = DomainController.getInstance().getQuestionById(q.getId());
        this.isNew = false;
        this.type = DomainController.getInstance().getTypeById(q.getQuestionType().getId());
        this.rulesMap = DomainController.getInstance().getQuestionRulesInfo(q);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(550, 550);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Question");
        } else {
            this.shell.setText("Edit Question");
        }
        this.setTitle("Question");
        this.setMessage("Enter the data for this question");
        this.setTitleImage(Activator.getImageDescriptor("questionIcon_48x48.png").createImage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        TabFolder tabs = new TabFolder(contents, 128);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        tabs.setLayout((Layout)new GridLayout());
        this.createInformationTab(tabs);
        this.createRulesTab(tabs);
        this.fillValues();
        return contents;
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Put this question: ");
        this.orderCombo = new Combo(content, 12);
        GridData gd0 = new GridData(4, 0x1000000, true, false);
        gd0.horizontalSpan = 2;
        this.orderCombo.setLayoutData((Object)gd0);
        this.fillComboValues();
        Label label2 = new Label(content, 0);
        label2.setText("Question: ");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 3;
        label2.setLayoutData((Object)gd1);
        this.questionText = new Text(content, 2048);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 3;
        this.questionText.setLayoutData((Object)gd2);
        Label label3 = new Label(content, 0);
        label3.setText("Type: ");
        GridData gd3 = new GridData(4, 0x1000000, true, false);
        gd3.horizontalSpan = 3;
        label3.setLayoutData((Object)gd3);
        this.typesList = new List(content, 2052);
        GridData gd4 = new GridData(0x1000000, 4, false, true);
        gd4.heightHint = 50;
        gd4.widthHint = 250;
        this.typesList.setLayoutData((Object)gd4);
        try {
            HashSet<DataType> types = Model.getTypes();
            for (DataType t : types) {
                this.typesList.add(t.getName());
            }
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void createRulesTab(TabFolder tabs) {
        TabItem tabitem = new TabItem(tabs, 0);
        tabitem.setText("Rules");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabitem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Rules:");
        Label label2 = new Label(content, 0);
        label2.setText("IF:");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        label2.setLayoutData((Object)gd1);
        this.rulesList = new List(content, 2052);
        GridData gd2 = new GridData(0x1000000, 4, false, true);
        gd2.verticalSpan = 4;
        gd2.heightHint = 100;
        gd2.widthHint = 60;
        this.rulesList.setLayoutData((Object)gd2);
        this.rulesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                QuestionDialog.this.questionsList.removeAll();
                QuestionDialog.this.restrictionText.setText("");
                HashMap res = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                for (String q : res.keySet()) {
                    QuestionDialog.this.questionsList.add(q);
                }
            }
        });
        this.questionsList = new List(content, 2820);
        GridData gd3 = new GridData(0x1000000, 0x1000000, false, false);
        gd3.verticalSpan = 2;
        gd3.heightHint = 120;
        gd3.widthHint = 200;
        this.questionsList.setLayoutData((Object)gd3);
        this.questionsList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                HashMap res = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                QuestionDialog.this.restrictionText.setText((String)res.get(QuestionDialog.this.questionsList.getSelection()[0]));
            }
        });
        Button addQuestionButton = new Button(content, 8);
        addQuestionButton.setText("Add");
        addQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (QuestionDialog.this.rulesList.getSelection().length != 0) {
                        ElementListSelectionDialog dg = new ElementListSelectionDialog(QuestionDialog.this.shell, (ILabelProvider)new QuestionLabelProvider());
                        HashSet<Question> allQuestions = Model.getQuestions();
                        HashSet<Question> validQuestions = new HashSet<Question>();
                        String[] items = QuestionDialog.this.questionsList.getItems();
                        for (Question q : allQuestions) {
                            boolean add = true;
                            int i = 0;
                            while (i < items.length) {
                                if (q.getText().equals(items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                            if (!add) continue;
                            validQuestions.add(q);
                        }
                        dg.setElements(validQuestions.toArray());
                        dg.setTitle("Browse Question");
                        dg.setMessage("Select a Question:");
                        dg.setMultipleSelection(false);
                        if (dg.open() == 0) {
                            Question result = (Question)dg.getFirstResult();
                            String qText = result.getText();
                            QuestionDialog.this.questionsList.add(qText);
                            HashMap res = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                            res.put(qText, "");
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, QuestionDialog.this.shell);
                    dd.open();
                }
            }
        });
        Button delQuestionButton = new Button(content, 8);
        delQuestionButton.setText("Delete");
        delQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (QuestionDialog.this.rulesList.getSelection().length != 0) {
                    HashMap res = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                    String selQuestion = QuestionDialog.this.questionsList.getSelection()[0];
                    QuestionDialog.this.questionsList.remove(selQuestion);
                    res.remove(selQuestion);
                    QuestionDialog.this.restrictionText.setText("");
                }
            }
        });
        Label label3 = new Label(content, 0);
        label3.setText("Restriction on the answer: ");
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        label3.setLayoutData((Object)gd4);
        this.restrictionText = new Text(content, 2818);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.horizontalSpan = 2;
        this.restrictionText.setLayoutData((Object)gd5);
        this.restrictionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (QuestionDialog.this.questionsList.getSelection().length == 0) {
                    QuestionDialog.this.questionsList.setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                HashMap selRes = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                selRes.put(QuestionDialog.this.questionsList.getSelection()[0], QuestionDialog.this.restrictionText.getText());
            }
        });
        Button addRule = new Button(content, 8);
        addRule.setText("New Rule");
        GridData gd6 = new GridData(1, 0x1000000, false, false);
        gd6.horizontalSpan = 3;
        addRule.setLayoutData((Object)gd6);
        addRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                InputDialog dg = new InputDialog(QuestionDialog.this.shell, "New Rule", "Introduce a name for the rule: ", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.equals("")) {
                            return "Introdue a Name";
                        }
                        return null;
                    }
                });
                if (dg.open() == 0) {
                    String rName = dg.getValue();
                    QuestionDialog.this.rulesList.add(rName);
                    QuestionDialog.this.rulesMap.put(rName, new HashMap());
                }
            }
        });
        Button delRule = new Button(content, 8);
        delRule.setText("Delete Rule");
        GridData gd7 = new GridData(1, 0x1000000, false, false);
        gd7.horizontalSpan = 3;
        delRule.setLayoutData((Object)gd7);
        delRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String rName = QuestionDialog.this.rulesList.getSelection()[0];
                QuestionDialog.this.rulesList.remove(rName);
                QuestionDialog.this.questionsList.removeAll();
                QuestionDialog.this.restrictionText.setText("");
                QuestionDialog.this.rulesMap.remove(rName);
            }
        });
    }

    private void fillValues() {
        if (!this.isNew) {
            this.questionText.setText(this.question.getText());
            String[] selType = new String[]{this.type.getName()};
            this.typesList.setSelection(selType);
            for (String qr : this.rulesMap.keySet()) {
                this.rulesList.add(qr);
            }
            this.orderCombo.select(this.question.getOrder() - 1);
        } else {
            this.orderCombo.select(this.orderCombo.getItemCount() - 1);
        }
    }

    private void fillComboValues() {
        try {
            HashSet<Question> allQ = Model.getQuestions();
            String[] toAdd = new String[allQ.size() + 1];
            toAdd[0] = "in the first place";
            for (Question q : allQ) {
                toAdd[q.getOrder()] = "after \"" + q.getText() + "\"";
            }
            this.orderCombo.setItems(toAdd);
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validRules() {
        try {
            int qOrder = this.orderCombo.getSelectionIndex() + 1;
            Iterator<String> iterator = this.rulesMap.keySet().iterator();
            block2: while (true) {
                String q;
                if (!iterator.hasNext()) {
                    return true;
                }
                String rule = iterator.next();
                HashMap<String, String> res = this.rulesMap.get(rule);
                if (res.isEmpty()) {
                    return false;
                }
                Iterator<String> iterator2 = res.keySet().iterator();
                do {
                    if (!iterator2.hasNext()) continue block2;
                    q = iterator2.next();
                    if (DomainController.getInstance().getQuestionFromText(q).getOrder() < qOrder) continue;
                    return false;
                } while (!res.get(q).equals(""));
                break;
            }
            return false;
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
            return false;
        }
    }

    protected void okPressed() {
        try {
            String qText = this.questionText.getText();
            String typeName = null;
            Long id = null;
            if (!this.isNew) {
                id = this.question.getId();
            }
            if (this.typesList.getSelection().length != 0) {
                typeName = this.typesList.getSelection()[0];
            }
            int qOrder = this.orderCombo.getSelectionIndex() + 1;
            if (qText == null || qText.equals("")) {
                this.showError("Error", "The text can't be empty");
            } else if (typeName == null) {
                this.showError("Error", "You have to select a type");
            } else if (!this.validRules()) {
                this.showError("Error", "There is some problem with the rules.\nCheck them");
            } else if (DomainController.getInstance().questionAlredyExists(qText, this.isNew, id)) {
                this.showError("Error", "A Question with the same text alredy exists");
            } else {
                if (this.isNew) {
                    DomainController.getInstance().newQuestion(typeName, qText, qOrder, this.rulesMap);
                } else {
                    DomainController.getInstance().updateQuestion(this.question, typeName, qText, qOrder, this.rulesMap);
                }
                super.okPressed();
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

