/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.dataTypes;

import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.types.TypeContentProvider;
import upc.gessi.architech.controller.types.TypeLabelProvider;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.domain.controller.Model;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.dataType.IntegerTypeDialog;
import upc.gessi.architech.hibernatehelper.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.domainModel.type.IntegerType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class DataTypesView
extends ViewPart {
    private final int INTEGER_TYPE_SELECTION = 0;
    private Action newTypeAction;
    private Action editTypeAction;
    private Action deleteTypeAction;
    Composite owner;
    Combo typeSelectorCombo;
    ListViewer typesList;
    private HashSet selectedTypes = null;
    int selIndex;
    Shell shell;

    public void createPartControl(Composite parent) {
        this.owner = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        this.typeSelectorCombo = new Combo(parent, 12);
        this.initComboEntrys();
        this.typeSelectorCombo.select(0);
        this.selIndex = 0;
        this.typeSelectorCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                int i = DataTypesView.this.typeSelectorCombo.getSelectionIndex();
                if (i != DataTypesView.this.selIndex) {
                    switch (i) {
                        case 0: {
                            DataTypesView.this.setIntegerTypes();
                        }
                    }
                }
                DataTypesView.this.selIndex = i;
            }
        });
        this.typesList = new ListViewer(parent);
        this.typesList.setContentProvider((IContentProvider)new TypeContentProvider());
        this.typesList.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        GridData gd = new GridData(4, 4, true, true);
        this.typesList.getList().setLayoutData((Object)gd);
        this.setIntegerTypes();
        this.getSite().setSelectionProvider((ISelectionProvider)this.typesList);
        this.shell = this.typesList.getControl().getShell();
        this.createActions();
        this.createMenu();
        this.addListeners();
        this.setEnabledActions();
    }

    public void setFocus() {
        this.typesList.getControl().setFocus();
        this.setIntegerTypes();
    }

    private void createActions() {
        this.newTypeAction = new Action("New Type", Activator.getImageDescriptor("add_16x16.png")){

            public void run() {
                switch (DataTypesView.this.selIndex) {
                    case 0: {
                        try {
                            IntegerTypeDialog td = new IntegerTypeDialog(DataTypesView.this.owner.getShell());
                            if (td.open() != 0) break;
                            DataTypesView.this.typesList.refresh();
                            break;
                        }
                        catch (Exception e) {
                            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DataTypesView.this.shell);
                            dd.open();
                        }
                    }
                }
            }
        };
        this.editTypeAction = new Action("Edit Type"){

            public void run() {
                if (!DataTypesView.this.typesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)DataTypesView.this.typesList.getSelection();
                    switch (DataTypesView.this.selIndex) {
                        case 0: {
                            try {
                                IntegerType selectedType = (IntegerType)sel.getFirstElement();
                                IntegerTypeDialog td = new IntegerTypeDialog(DataTypesView.this.owner.getShell(), selectedType);
                                td.open();
                                break;
                            }
                            catch (DomainException e) {
                                if (e.getCause() == null) {
                                    DataTypesView.this.showError("Error", e.getMessage());
                                    break;
                                }
                                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DataTypesView.this.shell);
                                dd.open();
                                break;
                            }
                            catch (Exception e) {
                                DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DataTypesView.this.shell);
                                dd.open();
                            }
                        }
                    }
                    DataTypesView.this.typesList.refresh();
                }
            }
        };
        this.deleteTypeAction = new Action("Delete Type", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                if (!DataTypesView.this.typesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)DataTypesView.this.typesList.getSelection();
                    DataType selectedType = (DataType)sel.getFirstElement();
                    try {
                        DomainController.getInstance().remove(selectedType);
                        DataTypesView.this.typesList.refresh();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            DataTypesView.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DataTypesView.this.shell);
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DataTypesView.this.shell);
                        dd.open();
                    }
                }
            }
        };
    }

    private void createMenu() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.add((IAction)this.newTypeAction);
        tmgr.add((IAction)this.deleteTypeAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)DataTypesView.this.editTypeAction);
                mgr.add((IAction)DataTypesView.this.deleteTypeAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.typesList.getControl());
        this.typesList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.typesList);
    }

    private void addListeners() {
        this.typesList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DataTypesView.this.editTypeAction.run();
            }
        });
        this.typesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataTypesView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        if (this.typesList.getSelection().isEmpty()) {
            enabledED = false;
        }
        this.editTypeAction.setEnabled(enabledED);
        this.deleteTypeAction.setEnabled(enabledED);
    }

    private void initComboEntrys() {
        this.typeSelectorCombo.add("Integer Types", 0);
    }

    private void setIntegerTypes() {
        try {
            this.selectedTypes = Model.getIntegerTypes();
            this.typesList.setInput((Object)this.selectedTypes);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

