/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.elements;

import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.domain.controller.Model;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class ElementsView
extends ViewPart {
    private Action newElementAction;
    private Action editElementAction;
    private Action deleteElementAction;
    private ListViewer elementsList;
    private Composite owner;
    private HashSet<Element> allElements = null;
    Shell shell;

    public void createPartControl(Composite parent) {
        try {
            this.owner = parent;
            this.elementsList = new ListViewer(parent);
            this.elementsList.setContentProvider((IContentProvider)new ElementContentProvider());
            this.elementsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
            if (this.allElements == null) {
                this.allElements = Model.getElements();
            }
            this.elementsList.setInput(this.allElements);
            this.getSite().setSelectionProvider((ISelectionProvider)this.elementsList);
            this.shell = this.elementsList.getControl().getShell();
            this.createActions();
            this.createMenu();
            this.addListeners();
            this.setEnabledActions();
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    public void createActions() {
        this.newElementAction = new Action("New Element", Activator.getImageDescriptor("add_16x16.png")){

            public void run() {
                try {
                    InputDialog ed = new InputDialog(ElementsView.this.owner.getShell(), "new Element", "Enter thename of the element", null, new IInputValidator(){

                        public String isValid(String s) {
                            try {
                                if (s.equals("")) {
                                    return new String("Introduce a name for the element");
                                }
                                if (DomainController.getInstance().elementAlredyExists(s, true, null)) {
                                    return new String("An element with the same name alredy exists");
                                }
                                return null;
                            }
                            catch (DomainException domainException) {
                                return new String("There is some trouble with the DataBase");
                            }
                        }
                    });
                    if (ed.open() == 0) {
                        DomainController.getInstance().newElement(ed.getValue());
                        ElementsView.this.elementsList.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.editElementAction = new Action("Edit Element"){

            public void run() {
                try {
                    if (!ElementsView.this.elementsList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsList.getSelection();
                        Element selectedElement = (Element)sel.getFirstElement();
                        final Long id = selectedElement.getId();
                        InputDialog ed = new InputDialog(ElementsView.this.owner.getShell(), "Edit Element", "Enter thename of the element", selectedElement.getName(), new IInputValidator(){

                            public String isValid(String s) {
                                try {
                                    if (s.equals("")) {
                                        return new String("Introduce a name for the element");
                                    }
                                    if (DomainController.getInstance().elementAlredyExists(s, false, id)) {
                                        return new String("An element with the same name alredy exists");
                                    }
                                    return null;
                                }
                                catch (DomainException domainException) {
                                    return new String("There is some trouble with the DataBase");
                                }
                            }
                        });
                        if (ed.open() == 0) {
                            DomainController.getInstance().updateElement(selectedElement, ed.getValue());
                            ElementsView.this.elementsList.refresh();
                        }
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.deleteElementAction = new Action("Delete Element", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                try {
                    if (!ElementsView.this.elementsList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsList.getSelection();
                        Element selectedElement = (Element)sel.getFirstElement();
                        DomainController.getInstance().remove(selectedElement);
                        ElementsView.this.elementsList.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        ElementsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
    }

    public void createMenu() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.add((IAction)this.newElementAction);
        tmgr.add((IAction)this.deleteElementAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)ElementsView.this.editElementAction);
                mgr.add((IAction)ElementsView.this.deleteElementAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.elementsList.getControl());
        this.elementsList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.elementsList);
    }

    private void addListeners() {
        this.elementsList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementsView.this.editElementAction.run();
            }
        });
        this.elementsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementsView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        if (this.elementsList.getSelection().isEmpty()) {
            enabledED = false;
        }
        this.editElementAction.setEnabled(enabledED);
        this.deleteElementAction.setEnabled(enabledED);
    }

    public ListViewer getElementsList() {
        return this.elementsList;
    }

    public void setFocus() {
        this.elementsList.getControl().setFocus();
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

