/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.properties;

import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.properties.PropertiesTreeContentProvider;
import upc.gessi.architech.controller.properties.PropertiesTreeLabelProvider;
import upc.gessi.architech.controller.properties.PropertiesTreeSorter;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.domain.controller.Model;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.property.PropertyDialog;
import upc.gessi.architech.gui.dialogs.property.RequirementDialog;
import upc.gessi.architech.hibernatehelper.domainModel.property.Property;
import upc.gessi.architech.hibernatehelper.domainModel.property.Requirement;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class PropertiesView
extends ViewPart {
    private Action newPropertyAction;
    private Action newRequirementAction;
    private Action editPropertyAction;
    private Action deletePropertyAction;
    private TreeViewer propertiesTree;
    private Composite owner;
    private HashSet<Requirement> allRequirements = null;
    Shell shell;

    public void createPartControl(Composite parent) {
        try {
            this.owner = parent;
            this.propertiesTree = new TreeViewer(parent);
            this.propertiesTree.setContentProvider((IContentProvider)new PropertiesTreeContentProvider());
            this.propertiesTree.setLabelProvider((IBaseLabelProvider)new PropertiesTreeLabelProvider());
            this.propertiesTree.setSorter((ViewerSorter)new PropertiesTreeSorter());
            if (this.allRequirements == null) {
                this.allRequirements = Model.getRequirements();
                this.allRequirements.add(DomainController.getInstance().getNotClassifiedRequirement());
            }
            this.propertiesTree.setInput(this.allRequirements);
            this.getSite().setSelectionProvider((ISelectionProvider)this.propertiesTree);
            this.shell = this.propertiesTree.getControl().getShell();
            this.createActions();
            this.createMenu();
            this.addListeners();
            this.setEnabledActions();
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    private void createActions() {
        this.newPropertyAction = new Action("New Property", Activator.getImageDescriptor("addProperty_16x16.png")){

            public void run() {
                try {
                    PropertyDialog pd = new PropertyDialog(PropertiesView.this.owner.getShell());
                    if (pd.open() == 0) {
                        PropertiesView.this.propertiesTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, PropertiesView.this.shell);
                    dd.open();
                }
            }
        };
        this.newRequirementAction = new Action("New Requirement", Activator.getImageDescriptor("addRequirement_16x16.png")){

            public void run() {
                try {
                    RequirementDialog rd = new RequirementDialog(PropertiesView.this.owner.getShell());
                    if (rd.open() == 0) {
                        PropertiesView.this.propertiesTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, PropertiesView.this.shell);
                    dd.open();
                }
            }
        };
        this.editPropertyAction = new Action("Edit"){

            public void run() {
                try {
                    if (!PropertiesView.this.propertiesTree.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)PropertiesView.this.propertiesTree.getSelection();
                        if (sel.getFirstElement() instanceof Requirement) {
                            Requirement selectedRequirement = (Requirement)sel.getFirstElement();
                            RequirementDialog rd = new RequirementDialog(PropertiesView.this.owner.getShell(), selectedRequirement);
                            rd.open();
                        } else if (sel.getFirstElement() instanceof Property) {
                            Property selectedProperty = (Property)sel.getFirstElement();
                            PropertyDialog pd = new PropertyDialog(PropertiesView.this.owner.getShell(), selectedProperty);
                            pd.open();
                        }
                        PropertiesView.this.propertiesTree.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        PropertiesView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, PropertiesView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, PropertiesView.this.shell);
                    dd.open();
                }
            }
        };
        this.deletePropertyAction = new Action("Delete", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                try {
                    if (!PropertiesView.this.propertiesTree.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)PropertiesView.this.propertiesTree.getSelection();
                        if (sel.getFirstElement() instanceof Property) {
                            Property selectedProperty = (Property)sel.getFirstElement();
                            DomainController.getInstance().remove(selectedProperty);
                        } else if (sel.getFirstElement() instanceof Requirement) {
                            Requirement selectedRequirement = (Requirement)sel.getFirstElement();
                            boolean del = true;
                            if (!selectedRequirement.getProperties().isEmpty()) {
                                del = MessageDialog.openConfirm((Shell)PropertiesView.this.shell, (String)"Delete Requirement", (String)"All the properties inside the requirement will be deleted.\nDo yo want to continue?");
                            }
                            if (del) {
                                DomainController.getInstance().remove(selectedRequirement);
                            }
                        }
                        PropertiesView.this.propertiesTree.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        PropertiesView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, PropertiesView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, PropertiesView.this.shell);
                    dd.open();
                }
            }
        };
    }

    private void createMenu() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.add((IAction)this.newRequirementAction);
        tmgr.add((IAction)this.newPropertyAction);
        tmgr.add((IAction)this.deletePropertyAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)PropertiesView.this.editPropertyAction);
                mgr.add((IAction)PropertiesView.this.deletePropertyAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.propertiesTree.getControl());
        this.propertiesTree.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.propertiesTree);
    }

    private void addListeners() {
        this.propertiesTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (PropertiesView.this.editPropertyAction.isEnabled()) {
                    PropertiesView.this.editPropertyAction.run();
                }
            }
        });
        this.propertiesTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertiesView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        try {
            boolean enabledED = true;
            if (!this.propertiesTree.getSelection().isEmpty()) {
                IStructuredSelection sel = (IStructuredSelection)this.propertiesTree.getSelection();
                if (sel.getFirstElement() instanceof Requirement && ((Requirement)sel.getFirstElement()).equals((Object)DomainController.getInstance().getNotClassifiedRequirement())) {
                    enabledED = false;
                }
            } else {
                enabledED = false;
            }
            this.editPropertyAction.setEnabled(enabledED);
            this.deletePropertyAction.setEnabled(enabledED);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    public TreeViewer getPropertiesTree() {
        return this.propertiesTree;
    }

    public void setFocus() {
        this.propertiesTree.getControl().setFocus();
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

