/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.questions;

import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.questions.QuestionContentProvider;
import upc.gessi.architech.controller.questions.QuestionLabelProvider;
import upc.gessi.architech.controller.questions.QuestionSorter;
import upc.gessi.architech.domain.controller.DomainController;
import upc.gessi.architech.domain.controller.Model;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.question.QuestionDialog;
import upc.gessi.architech.hibernatehelper.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class QuestionsView
extends ViewPart {
    private Action newQuestionAction;
    private Action editQuestionAction;
    private Action deleteQuestionAction;
    private Action orderUpAction;
    private Action orderDownAction;
    private ListViewer questionsList;
    private Composite owner;
    private HashSet<Question> allQuestions = null;
    Shell shell;

    public void createPartControl(Composite parent) {
        try {
            this.owner = parent;
            this.questionsList = new ListViewer(parent);
            this.questionsList.setContentProvider((IContentProvider)new QuestionContentProvider());
            this.questionsList.setLabelProvider((IBaseLabelProvider)new QuestionLabelProvider());
            this.questionsList.setSorter((ViewerSorter)new QuestionSorter());
            if (this.allQuestions == null) {
                this.allQuestions = Model.getQuestions();
            }
            this.questionsList.setInput(this.allQuestions);
            this.getSite().setSelectionProvider((ISelectionProvider)this.questionsList);
            this.shell = this.questionsList.getControl().getShell();
            this.createActions();
            this.createMenu();
            this.addListeners();
            this.setEnabledActions();
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, this.shell);
            dd.open();
        }
    }

    public void createActions() {
        this.newQuestionAction = new Action("New Question", Activator.getImageDescriptor("add_16x16.png")){

            public void run() {
                try {
                    QuestionDialog qd = new QuestionDialog(QuestionsView.this.owner.getShell());
                    if (qd.open() == 0) {
                        QuestionsView.this.questionsList.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.editQuestionAction = new Action("Edit Question"){

            public void run() {
                try {
                    if (!QuestionsView.this.questionsList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)QuestionsView.this.questionsList.getSelection();
                        Question selectedQuestion = (Question)sel.getFirstElement();
                        QuestionDialog qd = new QuestionDialog(QuestionsView.this.owner.getShell(), selectedQuestion);
                        qd.open();
                        QuestionsView.this.questionsList.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QuestionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.deleteQuestionAction = new Action("Delete Question", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                try {
                    if (!QuestionsView.this.questionsList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)QuestionsView.this.questionsList.getSelection();
                        Question selectedQuestion = (Question)sel.getFirstElement();
                        DomainController.getInstance().remove(selectedQuestion);
                        QuestionsView.this.questionsList.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QuestionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.orderUpAction = new Action("Go Up", Activator.getImageDescriptor("arrowUp_16x16.png")){

            public void run() {
                try {
                    IStructuredSelection selQuestion = (IStructuredSelection)QuestionsView.this.questionsList.getSelection();
                    int selIndex = QuestionsView.this.questionsList.getList().getSelectionIndex();
                    if (!selQuestion.isEmpty() && selIndex > 0) {
                        Question upQuestion = (Question)selQuestion.getFirstElement();
                        Question downQuestion = (Question)QuestionsView.this.questionsList.getElementAt(selIndex - 1);
                        DomainController.getInstance().swapQuestionsOrder(upQuestion, downQuestion);
                        QuestionsView.this.questionsList.refresh();
                        QuestionsView.this.setEnabledActions();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QuestionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.orderDownAction = new Action("Go Down", Activator.getImageDescriptor("arrowDown_16x16.png")){

            public void run() {
                try {
                    IStructuredSelection selQuestion = (IStructuredSelection)QuestionsView.this.questionsList.getSelection();
                    int selIndex = QuestionsView.this.questionsList.getList().getSelectionIndex();
                    if (!selQuestion.isEmpty() && selIndex < QuestionsView.this.questionsList.getList().getItemCount() - 1) {
                        Question downQuestion = (Question)selQuestion.getFirstElement();
                        Question upQuestion = (Question)QuestionsView.this.questionsList.getElementAt(selIndex + 1);
                        DomainController.getInstance().swapQuestionsOrder(upQuestion, downQuestion);
                        QuestionsView.this.questionsList.refresh();
                        QuestionsView.this.setEnabledActions();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QuestionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
    }

    public void createMenu() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.add((IAction)this.newQuestionAction);
        tmgr.add((IAction)this.deleteQuestionAction);
        tmgr.add((IContributionItem)new Separator());
        tmgr.add((IAction)this.orderUpAction);
        tmgr.add((IAction)this.orderDownAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)QuestionsView.this.editQuestionAction);
                mgr.add((IAction)QuestionsView.this.deleteQuestionAction);
                mgr.add((IAction)QuestionsView.this.orderUpAction);
                mgr.add((IAction)QuestionsView.this.orderDownAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.questionsList.getControl());
        this.questionsList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.questionsList);
    }

    private void addListeners() {
        this.questionsList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                QuestionsView.this.editQuestionAction.run();
            }
        });
        this.questionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QuestionsView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        boolean enabledU = true;
        boolean enabledD = true;
        if (this.questionsList.getSelection().isEmpty()) {
            enabledED = false;
            enabledU = false;
            enabledD = false;
        } else {
            int selIndex = this.questionsList.getList().getSelectionIndex();
            if (selIndex >= this.questionsList.getList().getItemCount() - 1) {
                enabledD = false;
            }
            if (selIndex == 0) {
                enabledU = false;
            }
        }
        this.editQuestionAction.setEnabled(enabledED);
        this.deleteQuestionAction.setEnabled(enabledED);
        this.orderUpAction.setEnabled(enabledU);
        this.orderDownAction.setEnabled(enabledD);
    }

    public ListViewer getQuestionsList() {
        return this.questionsList;
    }

    public void setFocus() {
        this.questionsList.getControl().setFocus();
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

