/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.persistence.property;

import java.io.Serializable;
import java.util.HashSet;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Query;
import upc.gessi.architech.hibernatehelper.HibernateController;
import upc.gessi.architech.hibernatehelper.domainModel.property.Property;

public class PropertyDAO {
    public static HashSet<Property> getAll() {
        String q = "from Property p join fetch p.type join fetch p.requirement";
        HashSet<Property> ps = new HashSet<Property>();
        ps.addAll(HibernateController.getSession().createQuery(q).list());
        q = "from Property p join fetch p.type where p.requirement is null";
        ps.addAll(HibernateController.getSession().createQuery(q).list());
        return ps;
    }

    public static void delete(Property p) {
        HibernateController.getSession().delete((Object)p);
    }

    public static Property getByName(String n) {
        String q = "from Property p where p.name like :name";
        Query query = HibernateController.getSession().createQuery(q);
        query.setString("name", n);
        return (Property)query.uniqueResult();
    }

    public static Property getById(Long id) {
        return (Property)HibernateController.getSession().get(Property.class, (Serializable)id);
    }

    public static void save(Property p) {
        HibernateController.getSession().save((Object)p);
    }

    public static void update(Property p) {
        try {
            HibernateController.getSession().update((Object)p);
        }
        catch (NonUniqueObjectException nonUniqueObjectException) {
            Property p2 = (Property)HibernateController.getSession().merge((Object)p);
            HibernateController.getSession().update((Object)p2);
        }
    }

    public static void lock(Property p) {
        try {
            HibernateController.getSession().lock((Object)p, LockMode.NONE);
        }
        catch (NonUniqueObjectException nonUniqueObjectException) {
            Property p2 = (Property)HibernateController.getSession().merge((Object)p);
            HibernateController.getSession().lock((Object)p2, LockMode.NONE);
        }
    }
}

