/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.persistence.question;

import java.io.Serializable;
import java.util.HashSet;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Query;
import upc.gessi.architech.hibernatehelper.HibernateController;
import upc.gessi.architech.hibernatehelper.domainModel.question.Question;

public class QuestionDAO {
    public static HashSet<Question> getAll() {
        String q = "from Question q join fetch q.questionType ";
        HashSet<Question> qs = new HashSet<Question>();
        qs.addAll(HibernateController.getSession().createQuery(q).list());
        return qs;
    }

    public static void delete(Question q) {
        HibernateController.getSession().delete((Object)q);
    }

    public static Question getByText(String t) {
        String q = "from Question q where q.text like :text";
        Query query = HibernateController.getSession().createQuery(q);
        query.setString("text", t);
        return (Question)query.uniqueResult();
    }

    public static Question getById(Long id) {
        return (Question)HibernateController.getSession().get(Question.class, (Serializable)id);
    }

    public static void save(Question q) {
        HibernateController.getSession().save((Object)q);
    }

    public static void update(Question q) {
        try {
            HibernateController.getSession().update((Object)q);
        }
        catch (NonUniqueObjectException nonUniqueObjectException) {
            Question q2 = (Question)HibernateController.getSession().merge((Object)q);
            HibernateController.getSession().update((Object)q2);
        }
    }

    public static void lock(Question q) {
        try {
            HibernateController.getSession().lock((Object)q, LockMode.NONE);
        }
        catch (NonUniqueObjectException nonUniqueObjectException) {
            Question q2 = (Question)HibernateController.getSession().merge((Object)q);
            HibernateController.getSession().lock((Object)q2, LockMode.NONE);
        }
    }
}

