/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.views.dataTypes.DataTypesView;
import upc.gessi.architech.gui.views.decisions.DecisionsView;
import upc.gessi.architech.gui.views.elements.ElementsView;
import upc.gessi.architech.gui.views.questions.QuestionsView;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.persistence.HibernateController;
import upc.gessi.architech.utils.StackTraceUtil;

public class Activator
extends AbstractUIPlugin {
    private FormColors formColors;
    public static final String PLUGIN_ID = "upc.gessi.ArchiTech";
    public static final String LOCATION_PREFERENCE = "last_db_location";
    public static final String DEFAULT_LOCATION = "~/database";
    public static final String USER_PREFERENCE = "user_db_location";
    public static final String DEFAULT_USER = "test";
    public static final String PASS_PREFERENCE = "pass_db_location";
    public static final String DEFAULT_PASS = "test";
    public static final String CREATE_PREFERENCE = "create";
    public static final String CURRENT_PROJECT_NAME_PREFERENCE = "current_project_name";
    private static Activator plugin;
    private static Shell shell;
    private static IPreferenceStore prefs;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        shell = this.getWorkbench().getDisplay().getActiveShell();
        prefs = this.getPreferenceStore();
        prefs.setValue(CREATE_PREFERENCE, false);
        Activator.initHibernate(prefs.getString(LOCATION_PREFERENCE), prefs.getString(USER_PREFERENCE), prefs.getString(PASS_PREFERENCE), prefs.getBoolean(CREATE_PREFERENCE));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        String iconPath = "icons/";
        try {
            URL installURL = Activator.getDefault().getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + name);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static void initHibernate(String dbLocation, String dbUser, String dbPath, boolean create) {
        try {
            HibernateController.initialize((String)dbLocation, (String)dbUser, (String)dbPath, (boolean)create);
            if (create) {
                DomainController.getInstance().createInitialData();
            }
            System.out.println("Hibernate inicialitzat correctament!");
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "There are some problmes with the DataBase.", StackTraceUtil.getStackTrace(e), 0, shell);
            dd.open();
        }
    }

    public static void connectToDatabase(String projectName, boolean create) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream fileContents = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile("DB_connection.xml").getContents();
            Document doc = db.parse(fileContents);
            NodeList nodeList = doc.getElementsByTagName("database-connection");
            Node main = nodeList.item(0);
            String location = null;
            String user = null;
            String pass = null;
            if (main.getNodeType() == 1) {
                Element connection = (Element)main;
                location = connection.getChildNodes().item(1).getFirstChild().getNodeValue();
                user = connection.getChildNodes().item(3).getFirstChild().getNodeValue();
                pass = connection.getChildNodes().item(5).getFirstChild().getNodeValue();
            }
            if (location != null && user != null && pass != null) {
                Activator.initHibernate(location, user, pass, create);
            } else {
                System.out.println("Error when parsing");
            }
            Activator.updatePreferences(location, user, pass, projectName, false);
            Model.getInstance().resetModel();
            Activator.refreshViewers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(LOCATION_PREFERENCE, DEFAULT_LOCATION);
        store.setDefault(USER_PREFERENCE, "test");
        store.setDefault(PASS_PREFERENCE, "test");
        store.setDefault(CREATE_PREFERENCE, true);
    }

    private static void updatePreferences(String dbLocation, String dbUser, String dbPass, String projectName, boolean dbCreate) {
        prefs.setValue(LOCATION_PREFERENCE, dbLocation);
        prefs.setValue(USER_PREFERENCE, dbUser);
        prefs.setValue(PASS_PREFERENCE, dbPass);
        prefs.setValue(CREATE_PREFERENCE, dbCreate);
        prefs.setValue(CURRENT_PROJECT_NAME_PREFERENCE, projectName);
    }

    private static void refreshViewers() {
        ((QuestionsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("upc.gessi.ArchiTech.QuestionsView")).refresh();
        ((ElementsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("upc.gessi.ArchiTech.ElementsView")).refresh();
        ((DecisionsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("upc.gessi.ArchiTech.DecisionsView")).refresh();
        ((DataTypesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("upc.gessi.ArchiTech.DataTypesView")).refresh();
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = Activator.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static String getCurrentProjectName() {
        return prefs.getString(CURRENT_PROJECT_NAME_PREFERENCE);
    }
}

