/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.dnd;

import java.awt.dnd.DragSourceAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.widgets.Shell;
import upc.gessi.architech.dnd.ElementTransfer;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ConcreteTechnology;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologyProduct;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class ElementDragListener
extends DragSourceAdapter
implements DragSourceListener {
    private StructuredViewer viewer;

    public ElementDragListener(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Element element = (Element)sel.getFirstElement();
        if (ElementTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = element;
        }
    }

    public void dragStart(DragSourceEvent event) {
        boolean canStart = false;
        try {
            IStructuredSelection sel;
            if (!this.viewer.getSelection().isEmpty() && ((sel = (IStructuredSelection)this.viewer.getSelection()).getFirstElement() instanceof ConcreteTechnology || sel.getFirstElement() instanceof TechnologyProduct && !sel.getFirstElement().equals(DomainController.getInstance().getNotClassifiedProduct()) || sel.getFirstElement() instanceof ArchitecturalUnit || sel.getFirstElement() instanceof TechnologicalUnit || sel.getFirstElement() instanceof TechnologicalStyle || sel.getFirstElement() instanceof ArchitecturalStyle)) {
                canStart = true;
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            }
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.viewer.getControl().getShell());
            dd.open();
        }
        event.doit = canStart;
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)title, (String)message);
    }
}

