/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.dnd;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import upc.gessi.architech.dnd.ElementTransfer;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ConcreteTechnology;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologyProduct;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class ElementsTreeDropAdapter
extends ViewerDropAdapter {
    TreeViewer viewer;

    public ElementsTreeDropAdapter(TreeViewer viewer) {
        super((Viewer)viewer);
        this.viewer = viewer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performDrop(Object data) {
        TreeViewer viewer;
        block14: {
            Element target = (Element)this.getCurrentTarget();
            Element toDrop = (Element)data;
            viewer = (TreeViewer)this.getViewer();
            try {
                if (toDrop.equals((Object)target)) {
                    return false;
                }
                if (toDrop instanceof ConcreteTechnology) {
                    if (target == null) {
                        return false;
                    }
                    ConcreteTechnology concreteTechnology = (ConcreteTechnology)toDrop;
                    DomainController.getInstance().changeConcreteTechnologyParent(concreteTechnology, (TechnologyProduct)target);
                    break block14;
                }
                if (toDrop instanceof TechnologyProduct) {
                    if (target != null && target.equals((Object)DomainController.getInstance().getNotClassifiedProduct())) {
                        return false;
                    }
                    TechnologyProduct technologyProduct = (TechnologyProduct)toDrop;
                    DomainController.getInstance().changeTechnologyProductParent(technologyProduct, (TechnologyProduct)target);
                    break block14;
                }
                if (toDrop instanceof ArchitecturalUnit) {
                    if (target == null) {
                        return false;
                    }
                    ArchitecturalUnit architecturalUnit = (ArchitecturalUnit)toDrop;
                    DomainController.getInstance().changeArchitecturalUnitParent(architecturalUnit, (ArchitecturalStyle)target);
                    break block14;
                }
                if (toDrop instanceof TechnologicalUnit) {
                    if (target == null) {
                        return false;
                    }
                    TechnologicalUnit technologicalUnit = (TechnologicalUnit)toDrop;
                    DomainController.getInstance().changeTechnologicalUnitParent(technologicalUnit, (TechnologicalStyle)target);
                    break block14;
                }
                if (toDrop instanceof TechnologicalStyle) {
                    TechnologicalStyle technologicalStyle = (TechnologicalStyle)toDrop;
                    DomainController.getInstance().changeTechnologicalStyleParent(technologicalStyle, (TechnologicalStyle)target);
                    break block14;
                }
                if (toDrop instanceof ArchitecturalStyle) {
                    ArchitecturalStyle architecturalStyle = (ArchitecturalStyle)toDrop;
                    DomainController.getInstance().changeArchitecturalStyleParent(architecturalStyle, (ArchitecturalStyle)target);
                }
            }
            catch (DomainException e) {
                if (e.getCause() == null) {
                    this.showError("Error", e.getMessage());
                    return false;
                }
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, viewer.getControl().getShell());
                dd.open();
                return false;
            }
        }
        viewer.refresh();
        return true;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        return ElementTransfer.getInstance().isSupportedType(type) && !(target instanceof ConcreteTechnology) && !(target instanceof ArchitecturalUnit) && !(target instanceof TechnologicalUnit);
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)title, (String)message);
    }
}

