/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DetailsDialog
extends IconAndMessageDialog {
    protected int tipoIcono;
    protected String detalles;
    protected Text textoDetalles;
    protected boolean textoDetallesCreado = false;
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFORMATION = 2;
    public static final int QUESTION = 3;
    protected Button botonDetalles;
    protected String titulo;

    public DetailsDialog(String titulo, String mensaje, String detalles, int tipoIcono, Shell parentShell) {
        this(titulo, mensaje, detalles, tipoIcono, parentShell, 1104);
    }

    public DetailsDialog(String titulo, String mensaje, String detalles, int tipoIcono, Shell parentShell, int estiloShell) {
        super(parentShell);
        if (mensaje == null) {
            throw new IllegalArgumentException("The input message cannot be null");
        }
        this.message = mensaje;
        if (tipoIcono < 0 || tipoIcono > 3) {
            throw new IllegalArgumentException("Invalid image type");
        }
        if (detalles == null) {
            throw new IllegalArgumentException("Details cannot be null");
        }
        if (titulo == null) {
            throw new IllegalArgumentException("Title cannot be null");
        }
        this.detalles = detalles;
        this.tipoIcono = tipoIcono;
        this.titulo = titulo;
        this.setBlockOnOpen(false);
        this.setShellStyle(estiloShell);
    }

    protected Control createDialogArea(Composite parent) {
        return this.createMessageArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        this.botonDetalles = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            Point dimensionAnteriorDialogo = this.getShell().getSize();
            if (this.textoDetallesCreado) {
                this.botonDetalles.setText(IDialogConstants.SHOW_DETAILS_LABEL);
                this.textoDetalles.dispose();
            } else {
                this.botonDetalles.setText(IDialogConstants.HIDE_DETAILS_LABEL);
                this.textoDetalles = new Text((Composite)this.getContents(), 2890);
                this.textoDetalles.setText(this.detalles);
                GridData data = new GridData(4, 4, true, true);
                this.textoDetalles.setBackground(Display.getCurrent().getSystemColor(1));
                data.horizontalSpan = 2;
                this.textoDetalles.setLayoutData((Object)data);
            }
            this.getContents().getShell().layout();
            this.textoDetallesCreado = !this.textoDetallesCreado;
            Point dimensionNuevaDialogo = this.getShell().computeSize(-1, -1);
            int altoPantalla = Display.getCurrent().getClientArea().height;
            this.getShell().setSize(new Point(dimensionAnteriorDialogo.x, Math.min(dimensionNuevaDialogo.y, altoPantalla)));
        } else {
            this.close();
        }
        this.setReturnCode(buttonId);
    }

    protected Image getImage() {
        switch (this.tipoIcono) {
            case 0: {
                return this.getErrorImage();
            }
            case 1: {
                return this.getWarningImage();
            }
            case 2: {
                return this.getInfoImage();
            }
            case 3: {
                return this.getQuestionImage();
            }
        }
        throw new RuntimeException("Invalid image type");
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.titulo);
    }
}

