/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.constraint;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.controller.decisions.DecisionContentProvider;
import upc.gessi.architech.controller.decisions.DecisionLabelProvider;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.constraint.GenericConstraintDialog;
import upc.gessi.architech.gui.dialogs.element.GenericElementDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class RestrictionDialog
extends GenericConstraintDialog {
    private ListViewer decisionsList;
    private Button buttonDelete;
    private TupleRestriction result;
    private Set<Decision> decisions;
    private String nameResult;
    private String elementName;

    public RestrictionDialog(Shell parentShell, GenericElementDialog dialog, String ownerName) {
        super(parentShell, dialog);
        this.result = new TupleRestriction();
        this.elementName = ownerName;
        this.decisions = new HashSet<Decision>();
    }

    public RestrictionDialog(Shell parentShell, String name, TupleRestriction restrictionData, GenericElementDialog dialog, String ownerName) throws DomainException {
        super(parentShell, name, dialog);
        this.result = restrictionData;
        this.elementName = ownerName;
        this.decisions = new HashSet<Decision>();
    }

    public TupleRestriction getResult() {
        return this.result;
    }

    public String getNameResult() {
        return this.nameResult;
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Restriction");
        this.setTitle("Restriction");
        this.setMessage("Enter the data fot this Restriction");
    }

    @Override
    public void createOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label = new Label(content, 0);
        label.setText("Restricted Decisions: ");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        label.setLayoutData((Object)gd1);
        this.decisionsList = new ListViewer(content, 2048);
        this.decisionsList.setContentProvider((IContentProvider)new DecisionContentProvider());
        this.decisionsList.setLabelProvider((IBaseLabelProvider)new DecisionLabelProvider());
        this.decisionsList.setInput(this.decisions);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.verticalSpan = 2;
        this.decisionsList.getList().setLayoutData((Object)gd2);
        this.decisionsList.getList().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                RestrictionDialog.this.buttonDelete.setEnabled(true);
            }
        });
        Button butt = new Button(content, 8);
        butt.setText("Add...");
        butt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(RestrictionDialog.this.getShell(), (ILabelProvider)new DecisionLabelProvider());
                    HashSet allDecisions = Model.getInstance().getDecisions();
                    HashSet<Decision> validDecisions = new HashSet<Decision>();
                    Object[] items = RestrictionDialog.this.getDecisionNames().toArray();
                    for (Decision d : allDecisions) {
                        boolean add;
                        boolean bl = add = RestrictionDialog.this.elementName == null || !d.getElement().getName().equals(RestrictionDialog.this.elementName);
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (d.getName().equals(items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validDecisions.add(d);
                    }
                    dg.setElements(validDecisions.toArray());
                    dg.setTitle("Browse Decision");
                    dg.setMessage("Select one or more decisions to restrict");
                    if (dg.open() == 0) {
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            RestrictionDialog.this.decisions.add((Decision)e);
                            RestrictionDialog.this.decisionsList.refresh();
                            ++n2;
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, RestrictionDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, RestrictionDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.buttonDelete = new Button(content, 8);
        this.buttonDelete.setText("Delete...");
        this.buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!RestrictionDialog.this.decisionsList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)RestrictionDialog.this.decisionsList.getSelection();
                    Decision selDecision = (Decision)sel.getFirstElement();
                    RestrictionDialog.this.decisions.remove(selDecision);
                    RestrictionDialog.this.decisionsList.refresh();
                    RestrictionDialog.this.buttonDelete.setEnabled(false);
                }
            }
        });
        this.buttonDelete.setEnabled(false);
    }

    @Override
    public void fillValuesSpecific() {
        Set ds = this.result.decisions;
        for (Decision d : ds) {
            this.decisions.add(d);
        }
        this.decisionsList.refresh();
    }

    @Override
    public void doOk(String name, boolean isNew) throws DomainException {
        this.nameResult = name;
        if (!isNew) {
            this.result.decisions.clear();
        }
        for (Decision d : this.decisions) {
            Decision res = DomainController.getInstance().getDecisionFromName(d.getName());
            this.result.decisions.add(res);
        }
    }

    private Set<String> getDecisionNames() {
        HashSet<String> decisionNames = new HashSet<String>();
        for (Decision aux : this.decisions) {
            decisionNames.add(aux.getName());
        }
        return decisionNames;
    }

    @Override
    public void initErrorsSpecific() {
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return null;
    }
}

