/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.dataType;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import upc.gessi.architech.Activator;
import upc.gessi.architech.gui.dialogs.dataType.GenericTypeDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.EnumerateType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.ErrorInfo;

public class EnumerateTypeDialog
extends GenericTypeDialog {
    List valuesList;
    Button delButton;
    EnumerateType type;
    Set<String> values;
    private static final int NUM_ERRORS_SPECIFIC = 1;
    private static final int ONE_VALUE = 0;
    private ErrorInfo[] errorsSpecific = new ErrorInfo[1];

    public EnumerateTypeDialog(Shell parentShell) {
        super(parentShell);
        this.values = new HashSet<String>();
    }

    public EnumerateTypeDialog(Shell parentShell, EnumerateType type) throws DomainException {
        super(parentShell, type.getName(), type.getDescription());
        this.values = new HashSet<String>();
        this.type = type = DomainController.getInstance().getEnumerateTypeById(type.getId());
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Enumerate Type");
        this.setTitle("Enumerate Type");
        this.setMessage("Enter the data fot this Enumerate Type");
        this.setTitleImage(Activator.getImageDescriptor("enumerateTypeIcon_48x48.png").createImage());
    }

    @Override
    public void createAttributesTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        GridData gd1 = new GridData(0x1000000, 0x1000000, false, false);
        gd1.horizontalSpan = 2;
        label1.setText("Values:");
        label1.setLayoutData((Object)gd1);
        this.valuesList = new List(content, 2820);
        GridData gd2 = new GridData(0x1000000, 0x1000000, false, false);
        gd2.horizontalSpan = 2;
        gd2.heightHint = 100;
        gd2.widthHint = 60;
        this.valuesList.setLayoutData((Object)gd2);
        this.valuesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr;
                EnumerateTypeDialog.this.delButton.setEnabled(true);
                boolean oldErr = ((EnumerateTypeDialog)EnumerateTypeDialog.this).errorsSpecific[0].isError;
                boolean bl = newErr = EnumerateTypeDialog.this.valuesList.getItemCount() == 0;
                if (oldErr != newErr) {
                    ((EnumerateTypeDialog)EnumerateTypeDialog.this).errorsSpecific[0].isError = newErr;
                    EnumerateTypeDialog.this.validate();
                }
            }
        });
        Button addValue = new Button(content, 8);
        addValue.setText("Add");
        addValue.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                InputDialog dg = new InputDialog(EnumerateTypeDialog.this.getShell(), "New Value", "Introduce a value", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.equals("")) {
                            return "Introdue a non-empty value";
                        }
                        return null;
                    }
                });
                if (dg.open() == 0) {
                    String vName = dg.getValue();
                    EnumerateTypeDialog.this.valuesList.add(vName);
                    EnumerateTypeDialog.this.values.add(vName);
                    boolean oldErr = ((EnumerateTypeDialog)EnumerateTypeDialog.this).errorsSpecific[0].isError;
                    boolean newErr = false;
                    if (oldErr != newErr) {
                        ((EnumerateTypeDialog)EnumerateTypeDialog.this).errorsSpecific[0].isError = newErr;
                        EnumerateTypeDialog.this.validate();
                    }
                }
            }
        });
        this.delButton = new Button(content, 8);
        this.delButton.setText("Delete");
        this.delButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr;
                String vName = EnumerateTypeDialog.this.valuesList.getSelection()[0];
                EnumerateTypeDialog.this.valuesList.remove(vName);
                EnumerateTypeDialog.this.values.remove(vName);
                EnumerateTypeDialog.this.delButton.setEnabled(false);
                boolean oldErr = false;
                boolean bl = newErr = EnumerateTypeDialog.this.valuesList.getItemCount() == 0;
                if (oldErr != newErr) {
                    ((EnumerateTypeDialog)EnumerateTypeDialog.this).errorsSpecific[0].isError = newErr;
                    EnumerateTypeDialog.this.validate();
                }
            }
        });
        this.delButton.setEnabled(false);
    }

    @Override
    public void fillValuesSpecific() {
        Set values = this.type.getValues();
        for (String value : values) {
            this.valuesList.add(value);
            this.values.add(value);
        }
    }

    @Override
    public void doOk(String name, String desc, boolean isNew) throws DomainException {
        if (isNew) {
            DomainController.getInstance().newEnumerateType(name, desc, this.values);
        } else {
            DomainController.getInstance().updateEnumerateType(this.type, name, desc, this.values);
        }
    }

    @Override
    public Long getTypeId() {
        return this.type.getId();
    }

    @Override
    public void initErrorsSpecific() {
        this.errorsSpecific[0] = new ErrorInfo("At least one value is required", 3, this.isNew());
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return this.errorsSpecific;
    }
}

