/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.decision;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.property.QualityAttributeSelectionDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.QualityAttribute;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class DecisionDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private TableViewer elementsList;
    private Combo typeCombo;
    private Text effectText;
    private List attributesList;
    private Button delAttributeButton;
    private boolean isNew;
    private Decision decision;
    private Element element;
    private HashMap<String, String> effectsMap;
    private Shell shell;
    private static final int NUM_ERRORS = 4;
    private static final int EMPTY_NAME = 0;
    private static final int ALREADY_EXISTS = 1;
    private static final int NO_ELEMENT = 2;
    private static final int NO_TYPE = 3;
    private ErrorInfo[] errors = new ErrorInfo[4];

    public DecisionDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.effectsMap = new HashMap();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DecisionDialog(Shell parentShell, Decision d) throws DomainException {
        super(parentShell);
        this.decision = d = DomainController.getInstance().getDecisionById(d.getId());
        this.isNew = false;
        this.element = DomainController.getInstance().getElementById(d.getElement().getId());
        this.effectsMap = new HashMap();
        DomainController.getInstance().getDecisionEffectsInfo(d, this.effectsMap);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(550, 650);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Decision");
        } else {
            this.shell.setText("Edit Decision");
        }
        this.setTitle("Decision");
        this.setMessage("Enter the data for this decision");
        this.setTitleImage(Activator.getImageDescriptor("decisionsIcon_48x48.png").createImage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        TabFolder tabs = new TabFolder(contents, 128);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        tabs.setLayout((Layout)new GridLayout());
        this.createInformationTab(tabs);
        this.createEffectsTab(tabs);
        this.initErrors();
        if (!this.isNew) {
            this.fillValues();
        }
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        GridData gd0 = new GridData(16384, 0x1000000, false, false);
        gd0.horizontalSpan = 2;
        label1.setText("Name: ");
        label1.setLayoutData((Object)gd0);
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 16384, true, false);
        this.nameText.setLayoutData((Object)gd1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    boolean oldErr1 = ((DecisionDialog)DecisionDialog.this).errors[0].isError;
                    boolean newErr1 = DecisionDialog.this.nameText.getText().length() == 0;
                    boolean oldErr2 = ((DecisionDialog)DecisionDialog.this).errors[1].isError;
                    Long id = null;
                    if (!DecisionDialog.this.isNew) {
                        id = DecisionDialog.this.decision.getId();
                    }
                    boolean newErr2 = DomainController.getInstance().decisionAlredyExists(DecisionDialog.this.nameText.getText(), DecisionDialog.this.isNew, id);
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((DecisionDialog)DecisionDialog.this).errors[0].isError = newErr1;
                        ((DecisionDialog)DecisionDialog.this).errors[1].isError = newErr2;
                        DecisionDialog.this.validate();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Description: ");
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 2;
        label2.setLayoutData((Object)gd2);
        this.descriptionText = new Text(content, 2626);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)gd3);
        Label label3 = new Label(content, 0);
        label3.setText("Element: ");
        Label label4 = new Label(content, 0);
        label4.setText("Action on the element: ");
        this.elementsList = new TableViewer(content, 2052);
        this.elementsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.elementsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.elementsList.setSorter((ViewerSorter)new ElementsSorter());
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.heightHint = 50;
        gd5.widthHint = 250;
        this.elementsList.getTable().setLayoutData((Object)gd5);
        try {
            HashSet allElements = Model.getInstance().getElements();
            HashSet validElements = new HashSet();
            validElements.addAll(allElements);
            validElements.remove(DomainController.getInstance().getNotClassifiedProduct());
            this.elementsList.setInput(validElements);
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
        this.elementsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr;
                boolean oldErr = ((DecisionDialog)DecisionDialog.this).errors[2].isError;
                boolean bl = newErr = DecisionDialog.this.elementsList.getTable().getSelectionCount() == 0;
                if (oldErr != newErr) {
                    ((DecisionDialog)DecisionDialog.this).errors[2].isError = newErr;
                    DecisionDialog.this.validate();
                }
            }
        });
        this.typeCombo = new Combo(content, 12);
        this.fillTypeComboValues();
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr;
                boolean oldErr = ((DecisionDialog)DecisionDialog.this).errors[3].isError;
                boolean bl = newErr = DecisionDialog.this.typeCombo.getSelectionIndex() == -1;
                if (oldErr != newErr) {
                    ((DecisionDialog)DecisionDialog.this).errors[3].isError = newErr;
                    DecisionDialog.this.validate();
                }
            }
        });
    }

    private void createEffectsTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Decision Effects");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Quality Attributes:");
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 3;
        label1.setLayoutData((Object)gd);
        this.attributesList = new List(content, 2820);
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.heightHint = 50;
        gd1.widthHint = 250;
        gd1.horizontalSpan = 2;
        gd1.verticalSpan = 2;
        this.attributesList.setLayoutData((Object)gd1);
        this.attributesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String selAttribute = DecisionDialog.this.attributesList.getSelection()[0];
                DecisionDialog.this.effectText.setText((String)DecisionDialog.this.effectsMap.get(selAttribute));
                DecisionDialog.this.delAttributeButton.setEnabled(true);
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Effect: ");
        GridData gd0 = new GridData(16384, 0x1000000, false, false);
        label2.setLayoutData((Object)gd0);
        this.effectText = new Text(content, 2048);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.widthHint = 300;
        this.effectText.setLayoutData((Object)gd2);
        this.effectText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (DecisionDialog.this.attributesList.getSelection().length == 0) {
                    DecisionDialog.this.attributesList.setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                DecisionDialog.this.effectsMap.put(DecisionDialog.this.attributesList.getSelection()[0], DecisionDialog.this.effectText.getText());
            }
        });
        Button addAttributeButton = new Button(content, 8);
        addAttributeButton.setText("Add...");
        addAttributeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    HashSet allAttributes = Model.getInstance().getQualityAttributes();
                    HashSet<QualityAttribute> usedAttributes = new HashSet<QualityAttribute>();
                    String[] items = DecisionDialog.this.attributesList.getItems();
                    block3: for (QualityAttribute a : allAttributes) {
                        int i = 0;
                        while (i < items.length) {
                            if (a.getName().equals(items[i])) {
                                usedAttributes.add(a);
                                continue block3;
                            }
                            ++i;
                        }
                    }
                    QualityAttributeSelectionDialog dialog = new QualityAttributeSelectionDialog(DecisionDialog.this.shell, usedAttributes);
                    dialog.setTitle("Browse Quality Attribute");
                    dialog.setMessage("Select a Quality Attribute:");
                    if (dialog.open() == 0) {
                        QualityAttribute result = (QualityAttribute)dialog.getFirstResult();
                        String pName = result.getName();
                        DecisionDialog.this.attributesList.add(pName);
                        DecisionDialog.this.effectsMap.put(result.getName(), "");
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.shell);
                    dd.open();
                }
            }
        });
        this.delAttributeButton = new Button(content, 8);
        this.delAttributeButton.setText("Delete...");
        this.delAttributeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String selAttribute = DecisionDialog.this.attributesList.getSelection()[0];
                DecisionDialog.this.attributesList.remove(selAttribute);
                DecisionDialog.this.effectsMap.remove(selAttribute);
                DecisionDialog.this.delAttributeButton.setEnabled(false);
            }
        });
        this.delAttributeButton.setEnabled(false);
    }

    private void fillValues() {
        this.typeCombo.select(this.decision.getType().intValue());
        this.nameText.setText(this.decision.getName());
        String pDescription = this.decision.getDescription();
        if (pDescription != null) {
            this.descriptionText.setText(pDescription);
        }
        this.elementsList.setSelection((ISelection)new StructuredSelection((Object)this.element), true);
        this.elementsList.refresh();
        for (String p : this.effectsMap.keySet()) {
            this.attributesList.add(p);
        }
    }

    private void fillTypeComboValues() {
        this.typeCombo.add("Needs", 0);
        this.typeCombo.add("Disallows", 1);
        this.typeCombo.add("Allows", 2);
        this.typeCombo.add("Uses", 3);
    }

    private boolean validEffects() {
        for (String key : this.effectsMap.keySet()) {
            String value = this.effectsMap.get(key);
            if (!value.equals("")) continue;
            return false;
        }
        return true;
    }

    protected void okPressed() {
        try {
            Integer dType = this.typeCombo.getSelectionIndex();
            String dName = this.nameText.getText();
            String dDescription = this.descriptionText.getText();
            String elementName = ((Element)((IStructuredSelection)this.elementsList.getSelection()).getFirstElement()).getName();
            if (!this.validEffects()) {
                this.setErrorMessage("There is some problem with the effects");
            } else {
                if (this.isNew) {
                    DomainController.getInstance().newDecision(dName, dDescription, elementName, this.effectsMap, dType);
                } else {
                    DomainController.getInstance().updateDecision(this.decision, dName, dDescription, elementName, this.effectsMap, dType);
                }
                super.okPressed();
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.setErrorMessage(e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initErrors() {
        this.errors[0] = new ErrorInfo("The name can't be empty", 3, this.isNew);
        this.errors[1] = new ErrorInfo("A decision with the same name alredy exists", 3, false);
        this.errors[2] = new ErrorInfo("You have to select an element", 3, this.isNew);
        this.errors[3] = new ErrorInfo("You have to select an action for the element", 3, this.isNew);
    }

    private void validate() {
        boolean error = false;
        ErrorInfo[] errorInfoArray = this.errors;
        int n = this.errors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorInfo err = errorInfoArray[n2];
            if (err.isError) {
                this.setErrorMessage(err.message);
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(!error);
    }
}

