/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import upc.gessi.architech.Activator;
import upc.gessi.architech.gui.dialogs.element.GenericStyleDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;

public class ArchitecturalStyleDialog
extends GenericStyleDialog {
    private ArchitecturalStyle architecturalStyle;
    private ArchitecturalStyle parent;

    public ArchitecturalStyleDialog(ArchitecturalStyle parent, Shell parentShell) throws DomainException {
        super(parentShell);
        this.parent = parent != null ? (parent = DomainController.getInstance().getArchitecturalStyleById(parent.getId())) : null;
    }

    public ArchitecturalStyleDialog(Shell parentShell, ArchitecturalStyle archStyle) throws DomainException {
        super(parentShell, archStyle.getName(), archStyle.getDescription());
        this.architecturalStyle = archStyle = DomainController.getInstance().getArchitecturalStyleById(archStyle.getId());
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Architectural Style");
        this.setTitle("Architectural Style");
        this.setMessage("Enter the data for this Architectural Style");
        this.setTitleImage(Activator.getImageDescriptor("architecturalStyleIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherOtherTabs(TabFolder tabs) {
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void fillValuesSpecificSpecific() throws DomainException {
        super.fillConstraintsAndValues((Element)this.architecturalStyle);
    }

    @Override
    public void doOkOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, boolean isNew) throws DomainException {
        String parentName = null;
        if (this.parent != null) {
            parentName = this.parent.getName();
        }
        if (isNew) {
            DomainController.getInstance().newArchitecturalStyle(name, desc, restrictionsMap, conditionsMap, valuesMap, parentName);
        } else {
            DomainController.getInstance().updateArchitecturalStyle(this.architecturalStyle, name, desc, restrictionsMap, conditionsMap, valuesMap);
        }
    }

    @Override
    public Class getClas() {
        return ArchitecturalStyle.class;
    }

    @Override
    public Long getElementId() {
        return this.architecturalStyle.getId();
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return null;
    }

    @Override
    public void initErrorsSpecific() {
    }
}

