/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.GenericUnitDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalComponentType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class ArchitecturalUnitDialog
extends GenericUnitDialog {
    private TableViewer typesList;
    private Button buttonDelete;
    private HashSet<ArchitecturalComponentType> types;
    private ArchitecturalUnit architecturalUnit;
    private ArchitecturalStyle parent;
    private static final int NUM_ERRORS_SPECIFIC = 1;
    private static final int NO_TYPES = 0;
    private ErrorInfo[] errorsSpecific = new ErrorInfo[1];

    public ArchitecturalUnitDialog(Shell parentShell, ArchitecturalStyle parent) throws DomainException {
        super(parentShell);
        this.types = new HashSet();
        this.parent = parent != null ? (parent = DomainController.getInstance().getArchitecturalStyleById(parent.getId())) : null;
    }

    public ArchitecturalUnitDialog(Shell parentShell, ArchitecturalUnit archUnit) throws DomainException {
        super(parentShell, archUnit.getName(), archUnit.getDescription());
        archUnit = DomainController.getInstance().getArchitecturalUnitById(archUnit.getId());
        this.types = new HashSet();
        this.architecturalUnit = archUnit;
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Architectural Unit");
        this.setTitle("Architectural Unit");
        this.setMessage("Enter the data for this Architectural Unit");
        this.setTitleImage(Activator.getImageDescriptor("architecturalUnitIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Unit Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label4 = new Label(content, 0);
        label4.setText("Uses the types: ");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 3;
        label4.setLayoutData((Object)gd1);
        this.typesList = new TableViewer(content, 2048);
        this.typesList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.typesList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.typesList.setSorter((ViewerSorter)new ElementsSorter());
        this.typesList.setInput(this.types);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.verticalSpan = 2;
        gd2.horizontalSpan = 2;
        this.typesList.getTable().setLayoutData((Object)gd2);
        this.typesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ArchitecturalUnitDialog.this.buttonDelete.setEnabled(true);
            }
        });
        Button butt = new Button(content, 8);
        butt.setText("Add");
        butt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(ArchitecturalUnitDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    HashSet allTypes = Model.getInstance().getArchitecturalComponentTypes();
                    HashSet<ArchitecturalComponentType> validTypes = new HashSet<ArchitecturalComponentType>();
                    Object[] items = ArchitecturalUnitDialog.this.getTypeNames().toArray();
                    for (ArchitecturalComponentType act : allTypes) {
                        boolean add = true;
                        int i = 0;
                        while (i < items.length) {
                            if (act.getName().equals(items[i])) {
                                add = false;
                            }
                            ++i;
                        }
                        if (!add) continue;
                        validTypes.add(act);
                    }
                    dg.setElements(validTypes.toArray());
                    dg.setTitle("Browse Architectural Component Types");
                    dg.setMessage("Select one or more types to add to the Unit");
                    if (dg.open() == 0) {
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            ArchitecturalUnitDialog.this.types.add((ArchitecturalComponentType)e);
                            ArchitecturalUnitDialog.this.typesList.refresh();
                            ++n2;
                        }
                        boolean oldErr = ((ArchitecturalUnitDialog)ArchitecturalUnitDialog.this).errorsSpecific[0].isError;
                        boolean newErr = false;
                        if (oldErr != newErr) {
                            ((ArchitecturalUnitDialog)ArchitecturalUnitDialog.this).errorsSpecific[0].isError = newErr;
                            ArchitecturalUnitDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ArchitecturalUnitDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ArchitecturalUnitDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.buttonDelete = new Button(content, 8);
        this.buttonDelete.setText("Delete");
        GridData gd5 = new GridData(131072, 0x1000000, false, false);
        this.buttonDelete.setLayoutData((Object)gd5);
        this.buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!ArchitecturalUnitDialog.this.typesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)ArchitecturalUnitDialog.this.typesList.getSelection();
                    Element selType = (Element)sel.getFirstElement();
                    ArchitecturalUnitDialog.this.types.remove(selType);
                    ArchitecturalUnitDialog.this.typesList.refresh();
                    ArchitecturalUnitDialog.this.buttonDelete.setEnabled(false);
                    boolean oldErr = false;
                    boolean newErr = ArchitecturalUnitDialog.this.types.isEmpty();
                    if (oldErr != newErr) {
                        ((ArchitecturalUnitDialog)ArchitecturalUnitDialog.this).errorsSpecific[0].isError = newErr;
                        ArchitecturalUnitDialog.this.validate();
                    }
                }
            }
        });
        this.buttonDelete.setEnabled(false);
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void fillValuesSpecificSpecific() throws DomainException {
        super.fillConstraintsAndValues((Element)this.architecturalUnit);
        Set types = this.architecturalUnit.getArchitecturalComponentTypes();
        for (ArchitecturalComponentType aux : types) {
            this.types.add(aux);
        }
        this.typesList.refresh();
        ArchitecturalStyle parent = this.architecturalUnit.getArchitecturalStyle();
        this.parent = parent = DomainController.getInstance().getArchitecturalStyleById(parent.getId());
    }

    @Override
    public void fillValuesWhenNew() {
    }

    @Override
    public void doOkOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, boolean isNew) throws DomainException {
        String styleName = null;
        if (this.parent != null) {
            styleName = this.parent.getName();
        }
        if (styleName == null) {
            throw new DomainException("You have to select a style");
        }
        if (isNew) {
            DomainController.getInstance().newArchitecturalUnit(name, desc, restrictionsMap, conditionsMap, valuesMap, this.types, styleName);
        } else {
            DomainController.getInstance().updateArchitecturalUnit(this.architecturalUnit, name, desc, restrictionsMap, conditionsMap, valuesMap, this.types, styleName);
        }
    }

    @Override
    public Class getClas() {
        return ArchitecturalUnit.class;
    }

    @Override
    public Long getElementId() {
        return this.architecturalUnit.getId();
    }

    private Set<String> getTypeNames() {
        HashSet<String> typeNames = new HashSet<String>();
        for (Element element : this.types) {
            typeNames.add(element.getName());
        }
        return typeNames;
    }

    @Override
    public void initErrorsSpecific() {
        this.errorsSpecific[0] = new ErrorInfo("The Unit must use at least one type", 3, this.isNew());
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return this.errorsSpecific;
    }
}

