/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.GenericElementDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologyProduct;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.StackTraceUtil;

public abstract class GenericComponentDialog
extends GenericElementDialog {
    private TableViewer componentsList;
    private Button buttonDelete;
    private HashSet<Component> components = new HashSet();
    private String name;

    public GenericComponentDialog(Shell parentShell) {
        super(parentShell);
        this.name = null;
    }

    public GenericComponentDialog(Shell parentShell, String name, String desc) {
        super(parentShell, name, desc);
        this.name = name;
    }

    @Override
    public void createOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Composed Components");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label4 = new Label(content, 0);
        label4.setText("This Component is composed of...: ");
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        label4.setLayoutData((Object)gd4);
        this.componentsList = new TableViewer(content, 2048);
        this.componentsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.componentsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.componentsList.setSorter((ViewerSorter)new ElementsSorter());
        this.componentsList.setInput(this.components);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.verticalSpan = 2;
        this.componentsList.getTable().setLayoutData((Object)gd5);
        this.componentsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                GenericComponentDialog.this.buttonDelete.setEnabled(true);
            }
        });
        Button butt = new Button(content, 8);
        butt.setText("Add");
        butt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(GenericComponentDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    HashSet allComponents = (HashSet)Model.getInstance().getMappingElements().get(GenericComponentDialog.this.getClas());
                    HashSet<Component> validComponents = new HashSet<Component>();
                    Object[] items = GenericComponentDialog.this.getComponentNames().toArray();
                    TechnologyProduct notC = DomainController.getInstance().getNotClassifiedProduct();
                    for (Component q : allComponents) {
                        boolean add;
                        boolean bl = add = (GenericComponentDialog.this.name == null || !q.getName().equals(GenericComponentDialog.this.name)) && !q.equals((Object)notC);
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (q.getName().equals(items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validComponents.add(q);
                    }
                    dg.setElements(validComponents.toArray());
                    dg.setTitle("Browse Component");
                    dg.setMessage("Select one or more components to add to the Component");
                    if (dg.open() == 0) {
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            GenericComponentDialog.this.components.add((Component)e);
                            GenericComponentDialog.this.componentsList.refresh();
                            ++n2;
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericComponentDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, GenericComponentDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.buttonDelete = new Button(content, 8);
        this.buttonDelete.setText("Delete");
        this.buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!GenericComponentDialog.this.componentsList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)GenericComponentDialog.this.componentsList.getSelection();
                    Element selComponent = (Element)sel.getFirstElement();
                    GenericComponentDialog.this.components.remove(selComponent);
                    GenericComponentDialog.this.componentsList.refresh();
                    GenericComponentDialog.this.buttonDelete.setEnabled(false);
                }
            }
        });
        this.buttonDelete.setEnabled(false);
        this.createOtherOtherTabs(tabs);
    }

    @Override
    public void doOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, boolean isNew) throws DomainException {
        this.doOkOk(name, desc, restrictionsMap, conditionsMap, valuesMap, this.components, isNew);
    }

    @Override
    public void fillValuesSpecific() throws DomainException {
        this.fillValuesSpecificSpecific();
    }

    public void fillConstraintsAndComponents(Component c) throws DomainException {
        super.fillConstraintsAndValues((Element)c);
        Set components = c.getComponentsComposedBy();
        for (Component aux : components) {
            this.components.add(aux);
        }
        this.componentsList.refresh();
    }

    private Set<String> getComponentNames() {
        HashSet<String> componentNames = new HashSet<String>();
        for (Component aux : this.components) {
            componentNames.add(aux.getName());
        }
        return componentNames;
    }

    public abstract void createOtherOtherTabs(TabFolder var1);

    public abstract void fillValuesSpecificSpecific() throws DomainException;

    public abstract void doOkOk(String var1, String var2, Map<String, TupleRestriction> var3, Map<String, TupleCondition> var4, Map<String, String> var5, HashSet<Component> var6, boolean var7) throws DomainException;

    public abstract Class getClas();
}

