/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.constraint.ConditionDialog;
import upc.gessi.architech.gui.dialogs.constraint.RestrictionDialog;
import upc.gessi.architech.gui.dialogs.property.ElementPropertySelectionDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public abstract class GenericElementDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text valueText;
    private Text descriptionText;
    private List restrictionsList;
    private List conditionsList;
    private List propertiesList;
    private Button delPropertyButton;
    private Label infoLabel;
    private boolean isNew;
    private String name;
    private String desc;
    private Map<String, TupleRestriction> restrictionsMap;
    private Map<String, TupleCondition> conditionsMap;
    private Map<String, String> valuesMap;
    private Shell shell;
    private static final int NUM_ERRORS = 2;
    private static final int EMPTY_NAME = 0;
    private static final int ALREADY_EXISTS = 1;
    private ErrorInfo[] errors = new ErrorInfo[2];

    public GenericElementDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.restrictionsMap = new HashMap<String, TupleRestriction>();
        this.conditionsMap = new HashMap<String, TupleCondition>();
        this.valuesMap = new HashMap<String, String>();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public GenericElementDialog(Shell parentShell, String name, String desc) {
        super(parentShell);
        this.isNew = false;
        this.name = name;
        this.desc = desc;
        this.restrictionsMap = new HashMap<String, TupleRestriction>();
        this.conditionsMap = new HashMap<String, TupleCondition>();
        this.valuesMap = new HashMap<String, String>();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(400, 400);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New ");
        } else {
            this.shell.setText("Edit ");
        }
        this.createContentsSpecific(this.shell);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        try {
            TabFolder tabs = new TabFolder(contents, 128);
            tabs.setLayoutData((Object)new GridData(4, 4, true, true));
            tabs.setLayout((Layout)new GridLayout());
            this.createInformationTab(tabs);
            this.createValuesTab(tabs);
            this.createOtherTabs(tabs);
            this.initErrors();
            if (!this.isNew) {
                this.fillValues();
            } else {
                this.fillValuesWhenNew();
            }
            return contents;
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
            return contents;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 1, true, false);
        gd1.horizontalSpan = 3;
        this.nameText.setLayoutData((Object)gd1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    boolean oldErr1 = ((GenericElementDialog)GenericElementDialog.this).errors[0].isError;
                    boolean newErr1 = GenericElementDialog.this.nameText.getText().length() == 0;
                    boolean oldErr2 = ((GenericElementDialog)GenericElementDialog.this).errors[1].isError;
                    Long id = null;
                    if (!GenericElementDialog.this.isNew) {
                        id = GenericElementDialog.this.getElementId();
                    }
                    boolean newErr2 = DomainController.getInstance().elementAlredyExists(GenericElementDialog.this.nameText.getText(), GenericElementDialog.this.isNew, id);
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((GenericElementDialog)GenericElementDialog.this).errors[0].isError = newErr1;
                        ((GenericElementDialog)GenericElementDialog.this).errors[1].isError = newErr2;
                        GenericElementDialog.this.validate();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Description: ");
        GridData gd0 = new GridData(4, 0x1000000, true, false);
        gd0.horizontalSpan = 4;
        label2.setLayoutData((Object)gd0);
        this.descriptionText = new Text(content, 2626);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 4;
        this.descriptionText.setLayoutData((Object)gd2);
        Label label3 = new Label(content, 0);
        label3.setText("Restrictions: ");
        GridData gd3 = new GridData(4, 0x1000000, true, false);
        gd3.horizontalSpan = 2;
        label3.setLayoutData((Object)gd3);
        Label label4 = new Label(content, 0);
        label4.setText("Conditions: ");
        GridData gd4 = new GridData(131072, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        label4.setLayoutData((Object)gd4);
        this.restrictionsList = new List(content, 2816);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.verticalSpan = 2;
        this.restrictionsList.setLayoutData((Object)gd5);
        GenericElementDialog me = this;
        this.restrictionsList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                String selRestriction = GenericElementDialog.this.restrictionsList.getSelection()[0];
                try {
                    RestrictionDialog dialog = new RestrictionDialog(GenericElementDialog.this.shell, selRestriction, (TupleRestriction)GenericElementDialog.this.restrictionsMap.get(selRestriction), me, GenericElementDialog.this.name);
                    if (dialog.open() == 0) {
                        TupleRestriction res = dialog.getResult();
                        GenericElementDialog.this.restrictionsMap.remove(selRestriction);
                        GenericElementDialog.this.restrictionsList.remove(selRestriction);
                        String restrictionName = dialog.getNameResult();
                        GenericElementDialog.this.restrictionsMap.put(restrictionName, res);
                        GenericElementDialog.this.restrictionsList.add(restrictionName);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button butt = new Button(content, 8);
        butt.setText("Add Restriction");
        GridData gd7 = new GridData(16384, 0x1000000, false, false);
        butt.setLayoutData((Object)gd7);
        butt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    RestrictionDialog dialog = new RestrictionDialog(GenericElementDialog.this.shell, me, GenericElementDialog.this.name);
                    if (dialog.open() == 0) {
                        TupleRestriction res = dialog.getResult();
                        String restrictionName = dialog.getNameResult();
                        GenericElementDialog.this.restrictionsMap.put(restrictionName, res);
                        GenericElementDialog.this.restrictionsList.add(restrictionName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Button butt3 = new Button(content, 8);
        butt3.setText("Add Condition");
        GridData gd8 = new GridData(131072, 0x1000000, false, false);
        butt3.setLayoutData((Object)gd8);
        butt3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ConditionDialog dialog = new ConditionDialog(GenericElementDialog.this.shell, me);
                if (dialog.open() == 0) {
                    TupleCondition res = dialog.getResult();
                    String conditionName = dialog.getNameResult();
                    GenericElementDialog.this.conditionsMap.put(conditionName, res);
                    GenericElementDialog.this.conditionsList.add(conditionName);
                }
            }
        });
        this.conditionsList = new List(content, 2816);
        GridData gd6 = new GridData(4, 4, true, true);
        gd6.verticalSpan = 2;
        this.conditionsList.setLayoutData((Object)gd6);
        this.conditionsList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                String selCondition = GenericElementDialog.this.conditionsList.getSelection()[0];
                try {
                    ConditionDialog dialog = new ConditionDialog(GenericElementDialog.this.shell, selCondition, (TupleCondition)GenericElementDialog.this.conditionsMap.get(selCondition), me);
                    if (dialog.open() == 0) {
                        TupleCondition res = dialog.getResult();
                        GenericElementDialog.this.conditionsMap.remove(selCondition);
                        GenericElementDialog.this.conditionsList.remove(selCondition);
                        String conditionName = dialog.getNameResult();
                        GenericElementDialog.this.conditionsMap.put(conditionName, res);
                        GenericElementDialog.this.conditionsList.add(conditionName);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button butt2 = new Button(content, 8);
        butt2.setText("Delete Restriction");
        GridData gd9 = new GridData(16384, 0x1000000, false, false);
        butt2.setLayoutData((Object)gd9);
        butt2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String rName = GenericElementDialog.this.restrictionsList.getSelection()[0];
                GenericElementDialog.this.restrictionsList.remove(rName);
                GenericElementDialog.this.restrictionsMap.remove(rName);
            }
        });
        Button butt4 = new Button(content, 8);
        butt4.setText("Delete Condition");
        GridData gd10 = new GridData(131072, 0x1000000, false, false);
        butt4.setLayoutData((Object)gd10);
        butt4.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String cName = GenericElementDialog.this.conditionsList.getSelection()[0];
                GenericElementDialog.this.conditionsList.remove(cName);
                GenericElementDialog.this.conditionsMap.remove(cName);
            }
        });
    }

    private void createValuesTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Property Values");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Properties:");
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 3;
        label1.setLayoutData((Object)gd);
        this.propertiesList = new List(content, 2820);
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.heightHint = 50;
        gd1.widthHint = 250;
        gd1.horizontalSpan = 2;
        gd1.verticalSpan = 3;
        this.propertiesList.setLayoutData((Object)gd1);
        this.propertiesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    String selProperty = GenericElementDialog.this.propertiesList.getSelection()[0];
                    GenericElementDialog.this.valueText.setText((String)GenericElementDialog.this.valuesMap.get(selProperty));
                    GenericElementDialog.this.delPropertyButton.setEnabled(true);
                    GenericElementDialog.this.setLabelInfo(selProperty);
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.shell);
                    dd.open();
                }
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Value: ");
        GridData gd0 = new GridData(16384, 0x1000000, false, false);
        label2.setLayoutData((Object)gd0);
        this.valueText = new Text(content, 2048);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.widthHint = 300;
        this.valueText.setLayoutData((Object)gd2);
        this.valueText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (GenericElementDialog.this.propertiesList.getSelection().length == 0) {
                    GenericElementDialog.this.propertiesList.setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                GenericElementDialog.this.valuesMap.put(GenericElementDialog.this.propertiesList.getSelection()[0], GenericElementDialog.this.valueText.getText());
            }
        });
        this.infoLabel = new Label(content, 64);
        GridData gd3 = new GridData(4, 0x1000000, true, false);
        this.infoLabel.setLayoutData((Object)gd3);
        Button addPropertyButton = new Button(content, 8);
        addPropertyButton.setText("Add...");
        addPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    HashSet allProperties = Model.getInstance().getElementProperties();
                    HashSet<ElementProperty> usedProperties = new HashSet<ElementProperty>();
                    String[] items = GenericElementDialog.this.propertiesList.getItems();
                    block3: for (ElementProperty p : allProperties) {
                        int i = 0;
                        while (i < items.length) {
                            if (p.getName().equals(items[i])) {
                                usedProperties.add(p);
                                continue block3;
                            }
                            ++i;
                        }
                    }
                    ElementPropertySelectionDialog dialog = new ElementPropertySelectionDialog(GenericElementDialog.this.shell, usedProperties);
                    dialog.setTitle("Browse Element Property");
                    dialog.setMessage("Select an Element Property:");
                    if (dialog.open() == 0) {
                        ElementProperty result = (ElementProperty)dialog.getFirstResult();
                        String pName = result.getName();
                        GenericElementDialog.this.propertiesList.add(pName);
                        GenericElementDialog.this.valuesMap.put(result.getName(), "");
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.shell);
                    dd.open();
                }
            }
        });
        this.delPropertyButton = new Button(content, 8);
        this.delPropertyButton.setText("Delete...");
        this.delPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String selProperty = GenericElementDialog.this.propertiesList.getSelection()[0];
                GenericElementDialog.this.propertiesList.remove(selProperty);
                GenericElementDialog.this.valuesMap.remove(selProperty);
                GenericElementDialog.this.delPropertyButton.setEnabled(false);
            }
        });
        this.delPropertyButton.setEnabled(false);
    }

    private void fillValues() throws DomainException {
        this.nameText.setText(this.name);
        if (this.desc != null) {
            this.descriptionText.setText(this.desc);
        }
        this.fillValuesSpecific();
    }

    public void fillConstraintsAndValues(Element element) throws DomainException {
        DomainController.getInstance().getElementConstraintsInfo(element, this.restrictionsMap, this.conditionsMap);
        DomainController.getInstance().getElementValuesInfo(element, this.valuesMap);
        for (String p : this.valuesMap.keySet()) {
            this.propertiesList.add(p);
        }
        for (String c : this.restrictionsMap.keySet()) {
            this.restrictionsList.add(c);
        }
        for (String c : this.conditionsMap.keySet()) {
            this.conditionsList.add(c);
        }
    }

    public boolean alredyHaveConstraint(String newName, String oldName) {
        String[] rests = this.restrictionsList.getItems();
        String[] conds = this.conditionsList.getItems();
        if (oldName == null) {
            String[] stringArray = rests;
            int n = rests.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                if (r.equals(newName)) {
                    return true;
                }
                ++n2;
            }
            stringArray = conds;
            n = conds.length;
            n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                if (c.equals(newName)) {
                    return true;
                }
                ++n2;
            }
        } else {
            String[] stringArray = rests;
            int n = rests.length;
            int n3 = 0;
            while (n3 < n) {
                String r = stringArray[n3];
                if (r.equals(newName) && !r.equals(oldName)) {
                    return true;
                }
                ++n3;
            }
            stringArray = conds;
            n = conds.length;
            n3 = 0;
            while (n3 < n) {
                String c = stringArray[n3];
                if (c.equals(newName) && !c.equals(oldName)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public boolean isNew() {
        return this.isNew;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validValues() {
        try {
            DataType type;
            String value;
            Iterator<String> iterator = this.valuesMap.keySet().iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                String key = iterator.next();
                value = this.valuesMap.get(key);
                ElementProperty prop = DomainController.getInstance().getElementPropertyFromName(key);
                type = DomainController.getInstance().getTypeById(prop.getType().getId());
            } while (!value.equals("") && type.isTypeOf(value));
            return false;
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
            return false;
        }
    }

    protected void okPressed() {
        try {
            String eName = this.nameText.getText();
            String eDescription = this.descriptionText.getText();
            if (!this.validValues()) {
                this.setErrorMessage("Some of the property values are not correct");
            } else {
                this.doOk(eName, eDescription, this.restrictionsMap, this.conditionsMap, this.valuesMap, this.isNew);
                super.okPressed();
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.setErrorMessage(e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknow Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initErrors() {
        this.errors[0] = new ErrorInfo("The name can't be empty", 3, this.isNew);
        this.errors[1] = new ErrorInfo("An element with the same name alredy exists", 3, false);
        this.initErrorsSpecific();
    }

    private void setLabelInfo(String selPropertyName) throws DomainException {
        ElementProperty prop = DomainController.getInstance().getElementPropertyFromName(selPropertyName);
        this.infoLabel.setText(prop.getType().toString());
    }

    public void validate() {
        ErrorInfo[] allErrors;
        boolean error = false;
        ErrorInfo[] errorsSpecific = this.getErrorsSpecific();
        if (errorsSpecific != null) {
            int numErrorsSpecific = errorsSpecific.length;
            allErrors = new ErrorInfo[2 + numErrorsSpecific];
            System.arraycopy(this.errors, 0, allErrors, 0, 2);
            System.arraycopy(errorsSpecific, 0, allErrors, 2, numErrorsSpecific);
        } else {
            allErrors = this.errors;
        }
        ErrorInfo[] errorInfoArray = allErrors;
        int n = allErrors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorInfo err = errorInfoArray[n2];
            if (err.isError) {
                this.setErrorMessage(err.message);
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(!error);
    }

    public void fillValuesWhenNew() {
    }

    public abstract void createContentsSpecific(Shell var1);

    public abstract void createOtherTabs(TabFolder var1);

    public abstract void fillValuesSpecific() throws DomainException;

    public abstract void doOk(String var1, String var2, Map<String, TupleRestriction> var3, Map<String, TupleCondition> var4, Map<String, String> var5, boolean var6) throws DomainException;

    public abstract Long getElementId();

    public abstract void initErrorsSpecific();

    public abstract ErrorInfo[] getErrorsSpecific();
}

