/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.GenericComponentDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalRole;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Technology;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologyProduct;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.StackTraceUtil;

public abstract class GenericTechnologyDialog
extends GenericComponentDialog {
    private TableViewer rolesList;
    private Button buttonAdd;
    private Button buttonDel;
    private HashSet<ListTechRole> techRoles = new HashSet();
    private TechnologyProduct parent;

    public GenericTechnologyDialog(Shell parentShell, TechnologyProduct parent) throws DomainException {
        super(parentShell);
        this.parent = parent != null ? (parent = DomainController.getInstance().getTechnologyProductById(parent.getId())) : null;
    }

    public GenericTechnologyDialog(Shell parentShell, String name, String desc) {
        super(parentShell, name, desc);
    }

    @Override
    public void createOtherOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Technology Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label4 = new Label(content, 0);
        label4.setText("Roles which can implement...: ");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 3;
        label4.setLayoutData((Object)gd1);
        this.rolesList = new TableViewer(content, 2048);
        this.rolesList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                HashSet techRoles = (HashSet)inputElement;
                return techRoles.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.rolesList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                ListTechRole t1 = (ListTechRole)o1;
                ListTechRole t2 = (ListTechRole)o2;
                if (t1.fromParent == t2.fromParent) {
                    return t1.technologicalRole.getName().compareTo(t2.technologicalRole.getName());
                }
                if (t1.fromParent) {
                    return -1;
                }
                return 1;
            }
        });
        this.rolesList.setLabelProvider((IBaseLabelProvider)new RolesLabelProvider());
        this.rolesList.setInput(this.techRoles);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.verticalSpan = 2;
        gd2.horizontalSpan = 2;
        gd2.heightHint = 50;
        gd2.widthHint = 150;
        this.rolesList.getTable().setLayoutData((Object)gd2);
        this.rolesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!GenericTechnologyDialog.this.rolesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)GenericTechnologyDialog.this.rolesList.getSelection();
                    ListTechRole selRole = (ListTechRole)sel.getFirstElement();
                    GenericTechnologyDialog.this.buttonDel.setEnabled(!selRole.fromParent);
                } else {
                    GenericTechnologyDialog.this.buttonDel.setEnabled(false);
                }
            }
        });
        this.buttonAdd = new Button(content, 8);
        this.buttonAdd.setText("Add");
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(GenericTechnologyDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    HashSet allRoles = Model.getInstance().getTechnologicalRoles();
                    HashSet<TechnologicalRole> validRoles = new HashSet<TechnologicalRole>();
                    Object[] items = GenericTechnologyDialog.this.getTechRoleNames().toArray();
                    for (TechnologicalRole tr : allRoles) {
                        boolean add = true;
                        int i = 0;
                        while (i < items.length) {
                            if (tr.getName().equals(items[i])) {
                                add = false;
                            }
                            ++i;
                        }
                        if (!add) continue;
                        validRoles.add(tr);
                    }
                    dg.setElements(validRoles.toArray());
                    dg.setTitle("Browse Technological Role");
                    dg.setMessage("Select one or more roles to add to the Technology");
                    if (dg.open() == 0) {
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            ListTechRole item = new ListTechRole();
                            item.technologicalRole = (TechnologicalRole)e;
                            item.fromParent = false;
                            GenericTechnologyDialog.this.techRoles.add(item);
                            GenericTechnologyDialog.this.rolesList.refresh();
                            ++n2;
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericTechnologyDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, GenericTechnologyDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.buttonDel = new Button(content, 8);
        this.buttonDel.setText("Delete");
        this.buttonDel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!GenericTechnologyDialog.this.rolesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)GenericTechnologyDialog.this.rolesList.getSelection();
                    ListTechRole selRole = (ListTechRole)sel.getFirstElement();
                    GenericTechnologyDialog.this.techRoles.remove(selRole);
                    GenericTechnologyDialog.this.rolesList.refresh();
                    GenericTechnologyDialog.this.buttonDel.setEnabled(false);
                }
            }
        });
        this.buttonDel.setEnabled(false);
        this.createOtherOtherTechnologyTabs(tabs);
    }

    @Override
    public void doOkOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> components, boolean isNew) throws DomainException {
        String parentName = null;
        if (this.parent != null) {
            parentName = this.parent.getName();
        }
        this.doOkOkTechnology(name, desc, restrictionsMap, conditionsMap, valuesMap, components, this.getTechRoles(), parentName, isNew);
    }

    @Override
    public void fillValuesSpecificSpecific() throws DomainException {
        this.fillValuesSpecificSpecificTechnology();
    }

    @Override
    public void fillValuesWhenNew() {
        try {
            if (this.parent != null) {
                this.addParentRoles(this.parent);
                this.rolesList.refresh();
            }
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.getShell());
            dd.open();
        }
    }

    public void fillTechnologyAttributes(Technology t) throws DomainException {
        super.fillConstraintsAndComponents((Component)t);
        this.addParentRoles(t.getTechnologyProduct());
        Set roles = t.getTechnologicalRoles();
        for (TechnologicalRole aux : roles) {
            ListTechRole item = new ListTechRole();
            item.technologicalRole = aux;
            item.fromParent = false;
            this.techRoles.add(item);
        }
        this.rolesList.refresh();
        TechnologyProduct tpParent = t.getTechnologyProduct();
        if (tpParent != null) {
            this.parent = tpParent = DomainController.getInstance().getTechnologyProductById(tpParent.getId());
        }
    }

    private void addParentRoles(TechnologyProduct tp) throws DomainException {
        if (tp != null) {
            tp = DomainController.getInstance().getTechnologyProductById(tp.getId());
            this.addParentRoles(tp.getTechnologyProduct());
            Set roles = tp.getTechnologicalRoles();
            for (TechnologicalRole aux : roles) {
                ListTechRole item = new ListTechRole();
                item.technologicalRole = aux;
                item.fromParent = true;
                this.techRoles.add(item);
            }
        }
    }

    private Set<String> getTechRoleNames() {
        HashSet<String> roles = new HashSet<String>();
        for (ListTechRole aux : this.techRoles) {
            roles.add(aux.technologicalRole.getName());
        }
        return roles;
    }

    private HashSet<TechnologicalRole> getTechRoles() {
        HashSet<TechnologicalRole> roles = new HashSet<TechnologicalRole>();
        for (ListTechRole aux : this.techRoles) {
            if (aux.fromParent) continue;
            roles.add(aux.technologicalRole);
        }
        return roles;
    }

    public abstract void createOtherOtherTechnologyTabs(TabFolder var1);

    public abstract void fillValuesSpecificSpecificTechnology() throws DomainException;

    public abstract void doOkOkTechnology(String var1, String var2, Map<String, TupleRestriction> var3, Map<String, TupleCondition> var4, Map<String, String> var5, HashSet<Component> var6, HashSet<TechnologicalRole> var7, String var8, boolean var9) throws DomainException;

    public abstract Technology getTechnology();

    private class ListTechRole {
        public TechnologicalRole technologicalRole;
        public boolean fromParent;

        private ListTechRole() {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.technologicalRole == null ? 0 : this.technologicalRole.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListTechRole other = (ListTechRole)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            return !(this.technologicalRole == null ? other.technologicalRole != null : !this.technologicalRole.equals((Object)other.technologicalRole));
        }

        private GenericTechnologyDialog getOuterType() {
            return GenericTechnologyDialog.this;
        }
    }

    private class RolesLabelProvider
    implements ILabelProvider,
    IColorProvider {
        private RolesLabelProvider() {
        }

        public Image getImage(Object element) {
            try {
                String path = ((ListTechRole)element).technologicalRole.getIconPath();
                ImageDescriptor id = Activator.getImageDescriptor(path);
                return id.createImage();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getText(Object element) {
            return ((ListTechRole)element).technologicalRole.getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ListTechRole listTechRole = (ListTechRole)element;
            if (listTechRole.fromParent) {
                return Display.getCurrent().getSystemColor(15);
            }
            return null;
        }
    }
}

