/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.GenericComponentDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalRole;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Technology;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologyProduct;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class TechnologicalRoleDialog
extends GenericComponentDialog {
    private TableViewer technologiesList;
    private Button buttonDel;
    private HashSet<Technology> technologies;
    private TechnologicalRole techRole;

    public TechnologicalRoleDialog(Shell parentShell) {
        super(parentShell);
        this.technologies = new HashSet();
    }

    public TechnologicalRoleDialog(Shell parentShell, TechnologicalRole techRole) throws DomainException {
        super(parentShell, techRole.getName(), techRole.getDescription());
        this.techRole = techRole = DomainController.getInstance().getTechnologicalRoleById(techRole.getId());
        this.technologies = new HashSet();
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Technological Role");
        this.setTitle("Technological Role");
        this.setMessage("Enter the data for this Technological Role");
        this.setTitleImage(Activator.getImageDescriptor("technologicalRoleIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Implementable By");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label4 = new Label(content, 0);
        label4.setText("Implementable by the technologies...: ");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 3;
        label4.setLayoutData((Object)gd1);
        this.technologiesList = new TableViewer(content, 2048);
        this.technologiesList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.technologiesList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.technologiesList.setSorter((ViewerSorter)new ElementsSorter());
        this.technologiesList.setInput(this.technologies);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.verticalSpan = 2;
        gd2.horizontalSpan = 2;
        gd2.heightHint = 50;
        gd2.widthHint = 150;
        this.technologiesList.getTable().setLayoutData((Object)gd2);
        this.technologiesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                TechnologicalRoleDialog.this.buttonDel.setEnabled(true);
            }
        });
        Button buttonAdd = new Button(content, 8);
        buttonAdd.setText("Add");
        buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(TechnologicalRoleDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    HashSet allTechnologies = Model.getInstance().getTechnologies();
                    HashSet<Technology> validTechnologies = new HashSet<Technology>();
                    Object[] items = TechnologicalRoleDialog.this.getTechnologyNames().toArray();
                    TechnologyProduct notC = DomainController.getInstance().getNotClassifiedProduct();
                    for (Technology t : allTechnologies) {
                        boolean add;
                        boolean bl = add = !t.equals((Object)notC);
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (t.getName().equals(items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validTechnologies.add(t);
                    }
                    dg.setElements(validTechnologies.toArray());
                    dg.setTitle("Browse Technological Role");
                    dg.setMessage("Select one or more roles to add to the Technology");
                    if (dg.open() == 0) {
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            TechnologicalRoleDialog.this.technologies.add((Technology)e);
                            TechnologicalRoleDialog.this.technologiesList.refresh();
                            ++n2;
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, TechnologicalRoleDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, TechnologicalRoleDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.buttonDel = new Button(content, 8);
        this.buttonDel.setText("Delete");
        this.buttonDel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!TechnologicalRoleDialog.this.technologiesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)TechnologicalRoleDialog.this.technologiesList.getSelection();
                    Technology selTech = (Technology)sel.getFirstElement();
                    TechnologicalRoleDialog.this.technologies.remove(selTech);
                    TechnologicalRoleDialog.this.technologiesList.refresh();
                    TechnologicalRoleDialog.this.buttonDel.setEnabled(false);
                }
            }
        });
        this.buttonDel.setEnabled(false);
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void fillValuesSpecificSpecific() throws DomainException {
        super.fillConstraintsAndComponents((Component)this.techRole);
        Set technologies = this.techRole.getTechnologies();
        for (Technology aux : technologies) {
            this.technologies.add(aux);
        }
        this.technologiesList.refresh();
    }

    @Override
    public void doOkOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> components, boolean isNew) throws DomainException {
        if (isNew) {
            DomainController.getInstance().newTehcnologicalRole(name, desc, restrictionsMap, conditionsMap, valuesMap, components, this.technologies);
        } else {
            DomainController.getInstance().updateTechnologicalRole(this.techRole, name, desc, restrictionsMap, conditionsMap, valuesMap, components, this.technologies);
        }
    }

    @Override
    public Class getClas() {
        return TechnologicalRole.class;
    }

    @Override
    public Long getElementId() {
        return this.techRole.getId();
    }

    private Set<String> getTechnologyNames() {
        HashSet<String> technologyNames = new HashSet<String>();
        for (Technology aux : this.technologies) {
            technologyNames.add(aux.getName());
        }
        return technologyNames;
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return null;
    }

    @Override
    public void initErrorsSpecific() {
    }
}

