/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import upc.gessi.architech.Activator;
import upc.gessi.architech.gui.dialogs.element.GenericStyleDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalStyle;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;

public class TechnologicalStyleDialog
extends GenericStyleDialog {
    private TechnologicalStyle technologicalStyle;
    private TechnologicalStyle parent;

    public TechnologicalStyleDialog(TechnologicalStyle parent, Shell parentShell) throws DomainException {
        super(parentShell);
        this.parent = parent != null ? (parent = DomainController.getInstance().getTechnologicalStyleById(parent.getId())) : null;
    }

    public TechnologicalStyleDialog(Shell parentShell, TechnologicalStyle techStyle) throws DomainException {
        super(parentShell, techStyle.getName(), techStyle.getDescription());
        this.technologicalStyle = techStyle = DomainController.getInstance().getTechnologicalStyleById(techStyle.getId());
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Technological Style");
        this.setTitle("Technological Style");
        this.setMessage("Enter the data for this Technological Style");
        this.setTitleImage(Activator.getImageDescriptor("technologicalStyleIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherOtherTabs(TabFolder tabs) {
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void fillValuesSpecificSpecific() throws DomainException {
        super.fillConstraintsAndValues((Element)this.technologicalStyle);
    }

    @Override
    public void doOkOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, boolean isNew) throws DomainException {
        String parentName = null;
        if (this.parent != null) {
            parentName = this.parent.getName();
        }
        if (isNew) {
            DomainController.getInstance().newTechnologicalStyle(name, desc, restrictionsMap, conditionsMap, valuesMap, parentName);
        } else {
            DomainController.getInstance().updateTechnologicalStyle(this.technologicalStyle, name, desc, restrictionsMap, conditionsMap, valuesMap);
        }
    }

    @Override
    public Class getClas() {
        return TechnologicalStyle.class;
    }

    @Override
    public Long getElementId() {
        return this.technologicalStyle.getId();
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return null;
    }

    @Override
    public void initErrorsSpecific() {
    }
}

