/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.GenericUnitDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalRole;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalUnit;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class TechnologicalUnitDialog
extends GenericUnitDialog {
    private TableViewer rolesList;
    private Button buttonDelete;
    private HashSet<TechnologicalRole> roles;
    private TechnologicalUnit technologicalUnit;
    private TechnologicalStyle parent;
    private static final int NUM_ERRORS_SPECIFIC = 1;
    private static final int NO_ROLES = 0;
    private ErrorInfo[] errorsSpecific = new ErrorInfo[1];

    public TechnologicalUnitDialog(Shell parentShell, TechnologicalStyle parent) throws DomainException {
        super(parentShell);
        this.roles = new HashSet();
        this.parent = parent != null ? (parent = DomainController.getInstance().getTechnologicalStyleById(parent.getId())) : null;
    }

    public TechnologicalUnitDialog(Shell parentShell, TechnologicalUnit techUnit) throws DomainException {
        super(parentShell, techUnit.getName(), techUnit.getDescription());
        techUnit = DomainController.getInstance().getTechnologicalUnitById(techUnit.getId());
        this.roles = new HashSet();
        this.technologicalUnit = techUnit;
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Technological Unit");
        this.setTitle("Technological Unit");
        this.setMessage("Enter the data for this Technological Unit");
        this.setTitleImage(Activator.getImageDescriptor("technologicalUnitIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Unit Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label4 = new Label(content, 0);
        label4.setText("Uses the roles: ");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 3;
        label4.setLayoutData((Object)gd1);
        this.rolesList = new TableViewer(content, 2048);
        this.rolesList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.rolesList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.rolesList.setSorter((ViewerSorter)new ElementsSorter());
        this.rolesList.setInput(this.roles);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.verticalSpan = 2;
        gd2.horizontalSpan = 2;
        this.rolesList.getTable().setLayoutData((Object)gd2);
        this.rolesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                TechnologicalUnitDialog.this.buttonDelete.setEnabled(true);
            }
        });
        Button butt = new Button(content, 8);
        butt.setText("Add");
        butt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(TechnologicalUnitDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    HashSet allRoles = Model.getInstance().getTechnologicalRoles();
                    HashSet<TechnologicalRole> validRoles = new HashSet<TechnologicalRole>();
                    Object[] items = TechnologicalUnitDialog.this.getRoleNames().toArray();
                    for (TechnologicalRole tr : allRoles) {
                        boolean add = true;
                        int i = 0;
                        while (i < items.length) {
                            if (tr.getName().equals(items[i])) {
                                add = false;
                            }
                            ++i;
                        }
                        if (!add) continue;
                        validRoles.add(tr);
                    }
                    dg.setElements(validRoles.toArray());
                    dg.setTitle("Browse Technological Roles");
                    dg.setMessage("Select one or more roles to add to the Unit");
                    if (dg.open() == 0) {
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            TechnologicalUnitDialog.this.roles.add((TechnologicalRole)e);
                            TechnologicalUnitDialog.this.rolesList.refresh();
                            ++n2;
                        }
                        boolean oldErr = ((TechnologicalUnitDialog)TechnologicalUnitDialog.this).errorsSpecific[0].isError;
                        boolean newErr = false;
                        if (oldErr != newErr) {
                            ((TechnologicalUnitDialog)TechnologicalUnitDialog.this).errorsSpecific[0].isError = newErr;
                            TechnologicalUnitDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, TechnologicalUnitDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, TechnologicalUnitDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.buttonDelete = new Button(content, 8);
        this.buttonDelete.setText("Delete");
        GridData gd5 = new GridData(131072, 0x1000000, false, false);
        this.buttonDelete.setLayoutData((Object)gd5);
        this.buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!TechnologicalUnitDialog.this.rolesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)TechnologicalUnitDialog.this.rolesList.getSelection();
                    Element selRole = (Element)sel.getFirstElement();
                    TechnologicalUnitDialog.this.roles.remove(selRole);
                    TechnologicalUnitDialog.this.rolesList.refresh();
                    TechnologicalUnitDialog.this.buttonDelete.setEnabled(false);
                    boolean oldErr = false;
                    boolean newErr = TechnologicalUnitDialog.this.roles.isEmpty();
                    if (oldErr != newErr) {
                        ((TechnologicalUnitDialog)TechnologicalUnitDialog.this).errorsSpecific[0].isError = newErr;
                        TechnologicalUnitDialog.this.validate();
                    }
                }
            }
        });
        this.buttonDelete.setEnabled(false);
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void fillValuesSpecificSpecific() throws DomainException {
        super.fillConstraintsAndValues((Element)this.technologicalUnit);
        Set roles = this.technologicalUnit.getTechnologicalRoles();
        for (TechnologicalRole aux : roles) {
            this.roles.add(aux);
        }
        this.rolesList.refresh();
        TechnologicalStyle parent = this.technologicalUnit.getTechnologicalStyle();
        this.parent = parent = DomainController.getInstance().getTechnologicalStyleById(parent.getId());
    }

    @Override
    public void fillValuesWhenNew() {
    }

    @Override
    public void doOkOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, boolean isNew) throws DomainException {
        String styleName = null;
        if (this.parent != null) {
            styleName = this.parent.getName();
        }
        if (styleName == null) {
            throw new DomainException("You have to select a style");
        }
        if (isNew) {
            DomainController.getInstance().newTechnologicalUnit(name, desc, restrictionsMap, conditionsMap, valuesMap, this.roles, styleName);
        } else {
            DomainController.getInstance().updateTechnologicalUnit(this.technologicalUnit, name, desc, restrictionsMap, conditionsMap, valuesMap, this.roles, styleName);
        }
    }

    @Override
    public Class getClas() {
        return TechnologicalUnit.class;
    }

    @Override
    public Long getElementId() {
        return this.technologicalUnit.getId();
    }

    private Set<String> getRoleNames() {
        HashSet<String> roleNames = new HashSet<String>();
        for (Element element : this.roles) {
            roleNames.add(element.getName());
        }
        return roleNames;
    }

    @Override
    public void initErrorsSpecific() {
        this.errorsSpecific[0] = new ErrorInfo("The Unit must use at least one roles", 3, this.isNew());
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return this.errorsSpecific;
    }
}

