/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import upc.gessi.architech.Activator;
import upc.gessi.architech.gui.dialogs.element.GenericTechnologyDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalRole;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Technology;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologyProduct;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;

public class TechnologyProductDialog
extends GenericTechnologyDialog {
    private TechnologyProduct techProduct;

    public TechnologyProductDialog(TechnologyProduct parent, Shell parentShell) throws DomainException {
        super(parentShell, parent);
    }

    public TechnologyProductDialog(Shell parentShell, TechnologyProduct techProduct) throws DomainException {
        super(parentShell, techProduct.getName(), techProduct.getDescription());
        this.techProduct = techProduct = DomainController.getInstance().getTechnologyProductById(techProduct.getId());
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Technology Product");
        this.setTitle("Technology Product");
        this.setMessage("Enter the data for this Technology Product");
        this.setTitleImage(Activator.getImageDescriptor("technologyProductIcon_48x48.png").createImage());
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(550, 650);
        return p;
    }

    @Override
    public void createOtherOtherTechnologyTabs(TabFolder tabs) {
    }

    @Override
    public void fillValuesSpecificSpecificTechnology() throws DomainException {
        super.fillTechnologyAttributes((Technology)this.techProduct);
    }

    @Override
    public void doOkOkTechnology(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> components, HashSet<TechnologicalRole> techRoles, String parentName, boolean isNew) throws DomainException {
        if (isNew) {
            DomainController.getInstance().newTechnologyProduct(name, desc, restrictionsMap, conditionsMap, valuesMap, components, techRoles, parentName);
        } else {
            DomainController.getInstance().updateTechnologyProduct(this.techProduct, name, desc, restrictionsMap, conditionsMap, valuesMap, components, techRoles, parentName);
        }
    }

    @Override
    public Class getClas() {
        return TechnologyProduct.class;
    }

    @Override
    public Long getElementId() {
        return this.techProduct.getId();
    }

    @Override
    public Technology getTechnology() {
        return this.techProduct;
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return null;
    }

    @Override
    public void initErrorsSpecific() {
    }
}

