/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.property;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import upc.gessi.architech.controller.properties.ElementPropertiesContentProvider;
import upc.gessi.architech.controller.properties.ElementPropertiesLabelProvider;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.property.ElementPropertyDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class ElementPropertySelectionDialog
extends SelectionStatusDialog {
    private ListViewer propertiesList;
    private Action newElementProperty;
    private Action delElementProperty;
    private Action editElementProperty;
    private HashSet<ElementProperty> usedProperties;
    private ISelectionStatusValidator validator;

    public ElementPropertySelectionDialog(Shell parent, HashSet<ElementProperty> usedProperties) {
        super(parent);
        this.usedProperties = usedProperties;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite res = (Composite)super.createDialogArea(parent);
        this.createMessageArea(res);
        this.createWidgets(parent);
        this.createMenu();
        this.createValidator();
        this.updateOkStatus();
        return res;
    }

    private void createWidgets(Composite parent) {
        try {
            this.propertiesList = new ListViewer(parent, 2052);
            this.propertiesList.setContentProvider((IContentProvider)new ElementPropertiesContentProvider());
            this.propertiesList.setLabelProvider((IBaseLabelProvider)new ElementPropertiesLabelProvider());
            this.propertiesList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ElementPropertySelectionDialog.this.setResult(((IStructuredSelection)event.getSelection()).toList());
                    ElementPropertySelectionDialog.this.updateOkStatus();
                }
            });
            this.propertiesList.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (ElementPropertySelectionDialog.this.editElementProperty.isEnabled()) {
                        ElementPropertySelectionDialog.this.editElementProperty.run();
                    }
                }
            });
            HashSet allProperties = Model.getInstance().getElementProperties();
            this.propertiesList.setInput((Object)allProperties);
            GridData data = new GridData(1808);
            data.widthHint = this.convertWidthInCharsToPixels(60);
            data.heightHint = this.convertHeightInCharsToPixels(18);
            this.propertiesList.getList().setLayoutData((Object)data);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.getShell());
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.getShell());
            dd.open();
        }
    }

    private void createValidator() {
        this.validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 0) {
                    ElementProperty selProperty = (ElementProperty)selection[0];
                    if (ElementPropertySelectionDialog.this.usedProperties.contains(selProperty)) {
                        return new Status(4, "upc.gessi.ArchiTech", 4, "This Property is alredy being used", null);
                    }
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void createMenu() {
        this.newElementProperty = new Action("New Element Property"){

            public void run() {
                try {
                    ElementPropertyDialog epd = new ElementPropertyDialog(ElementPropertySelectionDialog.this.getShell());
                    if (epd.open() == 0) {
                        ElementPropertySelectionDialog.this.propertiesList.refresh();
                        ElementPropertySelectionDialog.this.updateOkStatus();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementPropertySelectionDialog.this.getShell());
                    dd.open();
                }
            }
        };
        this.delElementProperty = new Action("Delete Element Property"){

            public void run() {
                try {
                    if (!ElementPropertySelectionDialog.this.propertiesList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)ElementPropertySelectionDialog.this.propertiesList.getSelection();
                        ElementProperty selectedProperty = (ElementProperty)sel.getFirstElement();
                        DomainController.getInstance().remove(selectedProperty);
                        ElementPropertySelectionDialog.this.propertiesList.refresh();
                        ElementPropertySelectionDialog.this.updateOkStatus();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        ElementPropertySelectionDialog.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementPropertySelectionDialog.this.getShell());
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementPropertySelectionDialog.this.getShell());
                    dd.open();
                }
            }
        };
        this.editElementProperty = new Action("Edit Element Property"){

            public void run() {
                if (!ElementPropertySelectionDialog.this.propertiesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)ElementPropertySelectionDialog.this.propertiesList.getSelection();
                    ElementProperty selectedProperty = (ElementProperty)sel.getFirstElement();
                    try {
                        ElementPropertyDialog epd = new ElementPropertyDialog(ElementPropertySelectionDialog.this.getShell(), selectedProperty);
                        epd.open();
                        ElementPropertySelectionDialog.this.propertiesList.refresh();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            ElementPropertySelectionDialog.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementPropertySelectionDialog.this.getShell());
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementPropertySelectionDialog.this.getShell());
                        dd.open();
                    }
                }
            }
        };
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)ElementPropertySelectionDialog.this.newElementProperty);
                mgr.add((IAction)ElementPropertySelectionDialog.this.delElementProperty);
                mgr.add((IAction)ElementPropertySelectionDialog.this.editElementProperty);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.propertiesList.getControl());
        this.propertiesList.getControl().setMenu(menu);
    }

    protected void updateOkStatus() {
        Object currentStatus = this.propertiesList.getSelection().isEmpty() ? new Status(4, "upc.gessi.ArchiTech", 4, "Select a property", null) : this.validator.validate(this.getResult());
        this.updateStatus((IStatus)currentStatus);
        this.setEnabledActions();
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        if (!this.propertiesList.getSelection().isEmpty()) {
            IStructuredSelection sel = (IStructuredSelection)this.propertiesList.getSelection();
            ElementProperty selProperty = (ElementProperty)sel.getFirstElement();
            if (this.usedProperties.contains(selProperty)) {
                enabledED = false;
            }
        } else {
            enabledED = false;
        }
        this.editElementProperty.setEnabled(enabledED);
        this.delElementProperty.setEnabled(enabledED);
    }

    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.propertiesList.getSelection()).toList());
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }
}

